/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.admin;

import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeCategory;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.AnalyzeTypeImpl;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class AnalyzeTypeAction
extends SgqActionSupport
implements Preparable {
    private static final long serialVersionUID = 6915148559808770928L;
    protected ReferentialService referentialService;
    protected List<AnalyzeCategory> analyzeCategories;
    protected AnalyzeType analyzeType;
    protected String analyzeCategoryId;

    public void prepare() throws Exception {
        this.referentialService = (ReferentialService)this.newService(ReferentialService.class);
    }

    public String input() throws Exception {
        this.analyzeCategories = this.referentialService.findAllAnalyzeCategories();
        return super.input();
    }

    public List<AnalyzeCategory> getAnalyzeCategories() {
        return this.analyzeCategories;
    }

    public void setAnalyzeCategoryId(String analyzeCategoryId) {
        this.analyzeCategoryId = analyzeCategoryId;
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "analyze-types"})})
    public String execute() throws Exception {
        AnalyzeCategory analyzeCategory = this.referentialService.findAnalyzeCategoryById(this.analyzeCategoryId);
        this.analyzeType.setAnalyzeCategory(analyzeCategory);
        this.referentialService.saveAnalyzeType(this.analyzeType);
        return super.execute();
    }

    public AnalyzeType getAnalyzeType() {
        if (this.analyzeType == null) {
            String analyzeId = this.getParameter("analyzeTypeId");
            if (StringUtils.isNotBlank((CharSequence)analyzeId)) {
                this.analyzeType = this.referentialService.findAnalyzeTypeById(analyzeId);
            } else {
                this.analyzeType = new AnalyzeTypeImpl();
                this.analyzeType.setDurationDays(30);
            }
        }
        return this.analyzeType;
    }
}

