/*
 * #%L
 * SGQ :: Web
 * $Id: AnalyzesReceiptAction.java 113 2012-10-02 14:38:07Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.3/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/AnalyzesReceiptAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.io.File;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Analyze;
import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.entities.SynthesisMention;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;

/**
 * Action de preparation des analyses pour plusieurs lots.
 * 
 * @author echatellier
 */
public class AnalyzesReceiptAction extends SgqActionSupport implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected ReferentialService referentialService;
    protected BatchService batchService;

    protected String analyzeId;

    protected Analyze analyze;

    protected List<Supplier> suppliers;

    protected String supplierId;

    protected String receiptDate;

    protected SynthesisMention mention;

    protected String synthesis;
    
    protected List<File> files;

    protected List<String> filesFileName;

    public void setAnalyzeId(String analyzeId) {
        this.analyzeId = analyzeId;
    }

    @Override
    public void prepare() throws Exception {
        referentialService = newService(ReferentialService.class);
        batchService = newService(BatchService.class);
    }

    @Override
    public String input() throws Exception {

        analyze = batchService.getAnalyzeById(analyzeId);
        suppliers = referentialService.getAllSupplierOnlyLabs();

        return super.input();
    }

    public Analyze getAnalyze() {
        return analyze;
    }

    public List<Supplier> getSuppliers() {
        return suppliers;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public void setFilesFileName(List<String> filesFileName) {
        this.filesFileName = filesFileName;
    }

    public void setReceiptDate(String receiptDate) {
        this.receiptDate = receiptDate;
    }

    public void setMention(SynthesisMention mention) {
        this.mention = mention;
    }

    public void setSupplierId(String supplierId) {
        this.supplierId = supplierId;
    }

    public void setSynthesis(String synthesis) {
        this.synthesis = synthesis;
    }

    public Date getNow() {
        return new Date();
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName", "analyzes-dashboard!input"})})
    public String execute() throws Exception {

        String result = SUCCESS;

        try {
            analyze = batchService.getAnalyzeById(analyzeId);
            Supplier supplier = referentialService.getSupplierById(supplierId);

            analyze.setSynthesisMention(mention);
            analyze.setSynthesis(synthesis);
    
            analyze.setReceiptDate(SgqUtils.parseSgqDate(receiptDate));

            batchService.receiveAnalyzeFromSupplier(analyze, supplier);

            if (files != null) {
                for (int i = 0; i < files.size(); i++) {
                    File file = files.get(i);
                    String fileName = filesFileName.get(i);
                    batchService.addAnalyzeFile(null, analyze, fileName, file);
                }
            }
        } catch (ParseException ex) {
            addActionError("Format de date invalide : dd/MM/yyyy");
            result = input();
        }

        return result;
    }
}
