/*
 * #%L
 * SGQ :: Web
 * $Id: PlacesAction.java 86 2012-09-21 11:56:23Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.3/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/PlacesAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import java.io.File;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class PlacesAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 7464265806217949750L;

    private static final Log log = LogFactory.getLog(PlacesAction.class);

    protected List<Place> places;

    protected File file;

    protected List<ImportLog<Place>> importLogs;

    @Override
    public String input() throws Exception {

        ReferentialService referentialService = newService(ReferentialService.class);
        places = referentialService.getPlaces();
        return super.input();
    }

    public List<Place> getPlaces() {
        return places;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public String execute() throws Exception {
        String result = super.execute();
        ReferentialService referentialService = newService(ReferentialService.class);
        try {
            importLogs = referentialService.importPlaces(file);
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't import places file", ex);
            }
            addActionError(ex.getMessage());
            result = input();
        }
        return result;
    }

    public List<ImportLog<Place>> getImportLogs() {
        return importLogs;
    }
}
