/*
 * #%L
 * SGQ :: Web
 * $Id: ClientsAction.java 116 2012-10-02 16:08:52Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.3/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/ClientsAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import java.io.File;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.PagerBean;

import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Client;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class ClientsAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4395441064634702753L;

    private static final Log log = LogFactory.getLog(ClientsAction.class);

    protected int page;

    protected PagerBean pager;

    protected List<Client> clients;

    protected File file;

    protected List<ImportLog<Client>> importLogs;

    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public String input() throws Exception {
        ReferentialService referentialService = newService(ReferentialService.class);
        clients = referentialService.getClients(ITEM_PER_PAGE  * page, ITEM_PER_PAGE);
        long totalCount = referentialService.getClientsCount();
        pager = getPager(page, ITEM_PER_PAGE, totalCount);
        return super.input();
    }

    public List<Client> getClients() {
        return clients;
    }
    
    public void setFile(File file) {
        this.file = file;
    }

    public PagerBean getPager() {
        return pager;
    }

    @Override
    public String execute() throws Exception {
        ReferentialService referentialService = newService(ReferentialService.class);

        String result = super.execute();
        try {
            importLogs = referentialService.importClients(file);
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't import client file", ex);
            }
            addActionError(ex.getMessage());
            result = input();
        }

        return result;
    }
    
    public List<ImportLog<Client>> getImportLogs() {
        return importLogs;
    }
}
