/*
 * #%L
 * SGQ :: Web
 * $Id: AnalyzesSendAction.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/AnalyzesSendAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Analyze;
import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action de preparation des analyses pour plusieurs lots.
 * 
 * @author echatellier
 */
public class AnalyzesSendAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected List<String> analyzeIds;

    public void setAnalyzeIds(List<String> analyzeIds) {
        this.analyzeIds = analyzeIds;
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName", "analyzes-dashboard"})})
    public String execute() throws Exception {

        ReferentialService referentialService = newService(ReferentialService.class);
        BatchService batchService = newService(BatchService.class);

        if (analyzeIds != null) {
            for (String analyzeId : analyzeIds) {
                Analyze analyze = batchService.getAnalyzeById(analyzeId);
    
                String supplierId = getParameter("supplier." + analyze.getTopiaId());
                Supplier supplier = referentialService.getSupplierById(supplierId);
                
                batchService.sendAnalyzeToSupplier(analyze, supplier);
            }
        }

        return SUCCESS;
    }
}
