/*
 * #%L
 * SGQ :: Web
 * $Id: AnalyzesReceiptProcessAction.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/AnalyzesReceiptProcessAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Analyze;
import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.entities.SynthesisMention;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action de preparation des analyses pour plusieurs lots.
 * 
 * @author echatellier
 */
public class AnalyzesReceiptProcessAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected String analyzeId;

    protected String mentionId;

    protected String supplierId;

    protected String synthesis;

    public void setAnalyzeId(String analyzeId) {
        this.analyzeId = analyzeId;
    }

    public void setMentionId(String mentionId) {
        this.mentionId = mentionId;
    }

    public void setSupplierId(String supplierId) {
        this.supplierId = supplierId;
    }

    public void setSynthesis(String synthesis) {
        this.synthesis = synthesis;
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName", "analyzes-dashboard"})})
    public String execute() throws Exception {

        ReferentialService referentialService = newService(ReferentialService.class);
        BatchService batchService = newService(BatchService.class);
        Analyze analyze = batchService.getAnalyzeById(analyzeId);
        Supplier supplier = referentialService.getSupplierById(supplierId);

        SynthesisMention synthesisMention = SynthesisMention.valueOf(mentionId);
        analyze.setSynthesisMention(synthesisMention);
        analyze.setSynthesis(synthesis);
        
        batchService.receiveAnalyzeFromSupplier(analyze, supplier);

        return SUCCESS;
    }
}
