/*
 * #%L
 * SGQ :: Web
 * $Id: AnalyzeTypeUpdateProcessAction.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/AnalyzeTypeUpdateProcessAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeCategory;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.AnalyzeTypeImpl;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class AnalyzeTypeUpdateProcessAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6915148559808770928L;

    protected String analyzeCategoryId;

    protected AnalyzeType analyzeType;

    protected ReferentialService referentialService;

    protected ReferentialService getReferentialService() {
        if (referentialService == null) {
            referentialService = newService(ReferentialService.class);
        }
        return referentialService;
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName" , "analyze-types"})})
    public String execute() throws Exception {

        AnalyzeCategory analyzeCategory = getReferentialService().findAnalyzeCategoryById(analyzeCategoryId);
        analyzeType.setAnalyzeCategory(analyzeCategory);
        getReferentialService().saveAnalyzeType(analyzeType);

        return SUCCESS;
    }

    public AnalyzeType getAnalyzeType() {
        if (analyzeType == null) {
            String analyzeId = getParameter("analyzeType.topiaId");
            if (StringUtils.isNotBlank(analyzeId)) {
                analyzeType = getReferentialService().findAnalyzeTypeById(analyzeId);
            } else {
                analyzeType = new AnalyzeTypeImpl();
            }
        }
        return analyzeType;
    }

    public void setAnalyzeCategoryId(String analyzeCategoryId) {
        this.analyzeCategoryId = analyzeCategoryId;
    }
}
