/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.url;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringParser;
import com.helger.base.string.StringReplace;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.stream.StreamHelperExt;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;

@ThreadSafe
public final class URLCleanser {
    private static char[] s_aCleanURLOld;
    private static char[][] s_aCleanURLNew;
    private static final URLCleanser INSTANCE;

    private URLCleanser() {
    }

    private static void _initCleanURL() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        StreamHelperExt.readStreamLines(ClassPathResource.getInputStream("codelists/cleanurl-data.dat", URLCleanser.class.getClassLoader()), StandardCharsets.UTF_8, string -> {
            if (string.length() > 0 && string.charAt(0) == '\"') {
                String[] stringArray = StringHelper.getExplodedArray((char)'=', (String)string, (int)2);
                String string2 = StringHelper.trimStartAndEnd((String)stringArray[0], (char)'\"');
                if (string2.startsWith("&#")) {
                    string2 = StringHelper.trimStartAndEnd((String)string2, (String)"&#", (String)";");
                    string2 = Character.toString((char)StringParser.parseInt((String)string2, (int)-1));
                }
                String string3 = StringHelper.trimStartAndEnd((String)stringArray[1], (char)'\"');
                linkedHashMap.put(string2, string3);
            }
        });
        s_aCleanURLOld = new char[linkedHashMap.size()];
        s_aCleanURLNew = new char[linkedHashMap.size()][];
        int n = 0;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            String string2 = (String)entry.getKey();
            if (string2.length() != 1) {
                throw new IllegalStateException("Clean URL source character has an invalid length: " + string2.length());
            }
            URLCleanser.s_aCleanURLOld[n] = string2.charAt(0);
            URLCleanser.s_aCleanURLNew[n] = ((String)entry.getValue()).toCharArray();
            ++n;
        }
    }

    public static @Nullable String getCleanURLPartWithoutUmlauts(@Nullable String string) {
        if (s_aCleanURLOld == null) {
            URLCleanser._initCleanURL();
        }
        char[] cArray = StringReplace.replaceMultiple((String)string, (char[])s_aCleanURLOld, (char[][])s_aCleanURLNew);
        return new String(cArray);
    }

    static {
        INSTANCE = new URLCleanser();
    }
}

