/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.resource.inmemory;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resource.inmemory.IMemoryReadableResource;
import java.io.File;
import java.net.URL;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class AbstractMemoryReadableResource
implements IMemoryReadableResource {
    private final String m_sResourceID;
    private String m_sPath = "";

    protected AbstractMemoryReadableResource(@NonNull @Nonempty String string) {
        this.m_sResourceID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ResourceID");
    }

    @Override
    public final @NonNull @Nonempty String getResourceID() {
        return this.m_sResourceID;
    }

    @Override
    public @NonNull String getPath() {
        return this.m_sPath;
    }

    public void setPath(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Path");
        this.m_sPath = string;
    }

    @Override
    public @Nullable URL getAsURL() {
        return null;
    }

    @Override
    public @Nullable File getAsFile() {
        return null;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public @NonNull IReadableResource getReadableCloneForPath(@NonNull String string) {
        throw new UnsupportedOperationException("Cannot clone in-memory resource '" + this.m_sResourceID + "' for path '" + string + "'");
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ResourceID", (Object)this.m_sResourceID).append("Path", (Object)this.m_sPath).getToString();
    }
}

