/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.system;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.misc.DevelopersNote;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.log.ConditionalLogger;
import com.helger.base.log.IHasConditionalLogger;
import com.helger.base.rt.NonBlockingProperties;
import com.helger.base.state.EChange;
import com.helger.base.string.StringParser;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SystemProperties
implements IHasConditionalLogger {
    public static final double JAVA_CLASS_VERSION = StringParser.parseDouble(SystemProperties.getJavaClassVersion(), Double.NaN);
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemProperties.class);
    private static final ConditionalLogger CONDLOG = new ConditionalLogger(LOGGER);
    @CodingStyleguideUnaware
    private static final Set<String> WARNED_PROP_NAMES = new CopyOnWriteArraySet<String>();
    private static final SystemProperties INSTANCE = new SystemProperties();

    private SystemProperties() {
    }

    public static boolean isSilentMode() {
        return CONDLOG.isDisabled();
    }

    public static boolean setSilentMode(boolean bl) {
        return !CONDLOG.setEnabled(!bl);
    }

    public static @Nullable String getPropertyValueOrNull(@Nullable String string) {
        return string == null ? null : System.getProperty(string);
    }

    public static @Nullable String getPropertyValue(@Nullable String string) {
        String string2 = null;
        if (string != null && (string2 = SystemProperties.getPropertyValueOrNull(string)) == null && WARNED_PROP_NAMES.add(string)) {
            CONDLOG.warn(() -> "System property '" + string + "' cannot be read because it is not set");
        }
        return string2;
    }

    public static void clearWarnedPropertyNames() {
        WARNED_PROP_NAMES.clear();
    }

    @ReturnsMutableCopy
    public static @NonNull Set<String> getAllWarnedPropertyNames() {
        return new HashSet<String>(WARNED_PROP_NAMES);
    }

    public static @NonNull EChange setPropertyValue(@NonNull String string, boolean bl) {
        return SystemProperties.setPropertyValue(string, Boolean.toString(bl));
    }

    public static @NonNull EChange setPropertyValue(@NonNull String string, int n) {
        return SystemProperties.setPropertyValue(string, Integer.toString(n));
    }

    public static @NonNull EChange setPropertyValue(@NonNull String string, long l) {
        return SystemProperties.setPropertyValue(string, Long.toString(l));
    }

    public static @NonNull EChange setPropertyValue(@NonNull String string, @Nullable String string2) {
        boolean bl;
        if (string2 == null) {
            bl = SystemProperties.removePropertyValue(string) != null;
        } else {
            String string3 = System.setProperty(string, string2);
            boolean bl2 = bl = string3 != null && !string2.equals(string3);
            if (bl) {
                CONDLOG.info(() -> "Set system property '" + string + "' to '" + string2 + "'");
            }
        }
        return EChange.valueOf(bl);
    }

    public static @Nullable String removePropertyValue(@NonNull String string) {
        String string2 = System.clearProperty(string);
        if (string2 != null) {
            CONDLOG.info(() -> "Removed system property '" + string + "' with value '" + string2 + "'");
        } else {
            CONDLOG.warn(() -> "Remove system property '" + string + "' failed");
        }
        return string2;
    }

    public static @Nullable String getJavaVersion() {
        return SystemProperties.getPropertyValue("java.version");
    }

    public static @Nullable String getJavaVendor() {
        return SystemProperties.getPropertyValue("java.vendor");
    }

    public static @Nullable String getJavaVendorURL() {
        return SystemProperties.getPropertyValue("java.vendor.url");
    }

    public static @Nullable String getJavaHome() {
        return SystemProperties.getPropertyValue("java.home");
    }

    public static @Nullable String getJavaClassVersion() {
        return SystemProperties.getPropertyValue("java.class.version");
    }

    public static @Nullable String getJavaClassPath() {
        return SystemProperties.getPropertyValue("java.class.path");
    }

    public static @Nullable String getJavaLibraryPath() {
        return SystemProperties.getPropertyValue("java.library.path");
    }

    public static @Nullable String getOsName() {
        return SystemProperties.getPropertyValue("os.name");
    }

    public static @Nullable String getOsArch() {
        return SystemProperties.getPropertyValue("os.arch");
    }

    public static @Nullable String getOsVersion() {
        return SystemProperties.getPropertyValue("os.version");
    }

    public static @Nullable String getFileSeparator() {
        return SystemProperties.getPropertyValue("file.separator");
    }

    public static @Nullable String getPathSeparator() {
        return SystemProperties.getPropertyValue("path.separator");
    }

    public static @Nullable String getLineSeparator() {
        return System.lineSeparator();
    }

    public static @Nullable String getUserName() {
        return SystemProperties.getPropertyValue("user.name");
    }

    public static @Nullable String getUserHome() {
        return SystemProperties.getPropertyValue("user.home");
    }

    public static @Nullable String getUserDir() {
        return SystemProperties.getPropertyValue("user.dir");
    }

    public static @Nullable String getJavaVmName() {
        return SystemProperties.getPropertyValue("java.vm.name");
    }

    public static @Nullable String getJavaVmSpecificationVersion() {
        return SystemProperties.getPropertyValue("java.vm.specification.version");
    }

    public static @Nullable String getJavaVmSpecificationVendor() {
        return SystemProperties.getPropertyValue("java.vm.specification.vendor");
    }

    public static @Nullable String getJavaVmSpecificationUrl() {
        return SystemProperties.getPropertyValue("java.vm.specification.url");
    }

    public static @Nullable String getJavaVmVersion() {
        return SystemProperties.getPropertyValue("java.vm.version");
    }

    public static @Nullable String getJavaVmVendor() {
        return SystemProperties.getPropertyValue("java.vm.vendor");
    }

    public static @Nullable String getJavaVmUrl() {
        return SystemProperties.getPropertyValue("java.vm.url");
    }

    public static @Nullable String getJavaSpecificationVersion() {
        return SystemProperties.getPropertyValue("java.specification.version");
    }

    public static @Nullable String getJavaSpecificationVendor() {
        return SystemProperties.getPropertyValue("java.specification.vendor");
    }

    public static @Nullable String getJavaSpecificationUrl() {
        return SystemProperties.getPropertyValue("java.specification.url");
    }

    @DevelopersNote(value="This property is not part of the language but part of the Sun SDK")
    public static @Nullable String getTmpDir() {
        return SystemProperties.getPropertyValue("java.io.tmpdir");
    }

    public static @Nullable String getJavaRuntimeVersion() {
        return SystemProperties.getPropertyValue("java.runtime.version");
    }

    public static @Nullable String getJavaRuntimeName() {
        return SystemProperties.getPropertyValue("java.runtime.name");
    }

    @ReturnsMutableCopy
    public static @NonNull NonBlockingProperties getAllProperties() {
        Properties properties = System.getProperties();
        if (properties == null) {
            return new NonBlockingProperties();
        }
        NonBlockingProperties nonBlockingProperties = new NonBlockingProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            nonBlockingProperties.put(Objects.toString(entry.getKey()), Objects.toString(entry.getValue()));
        }
        return nonBlockingProperties;
    }

    @ReturnsMutableCopy
    public static @NonNull Set<String> getAllPropertyNames() {
        HashSet<String> hashSet = new HashSet<String>();
        Properties properties = System.getProperties();
        if (properties != null) {
            for (Object object : properties.keySet()) {
                hashSet.add(Objects.toString(object));
            }
        }
        return hashSet;
    }

    public static boolean containsPropertyName(String string) {
        return SystemProperties.getAllProperties().containsKey(string);
    }

    @ReturnsMutableCopy
    public static @NonNull String[] getAllJavaNetSystemProperties() {
        return new String[]{"javax.net.debug", "java.security.debug", "java.net.useSystemProxies", "http.proxyHost", "http.proxyPort", "http.nonProxyHosts", "https.proxyHost", "https.proxyPort"};
    }
}

