/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.core.behavior;

import com.googlecode.wicket.jquery.core.behavior.AjaxCallbackBehavior;
import com.googlecode.wicket.jquery.core.data.IChoiceProvider;
import com.googlecode.wicket.jquery.core.renderer.ITextRenderer;
import com.googlecode.wicket.jquery.core.template.IJQueryTemplate;
import com.googlecode.wicket.jquery.core.utils.BuilderUtils;
import com.googlecode.wicket.jquery.core.utils.ListUtils;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.request.IRequestParameters;

public abstract class ChoiceModelBehavior<T>
extends AjaxCallbackBehavior
implements IChoiceProvider<T> {
    private static final long serialVersionUID = 1L;
    protected final ITextRenderer<? super T> renderer;
    protected final IJQueryTemplate template;

    public ChoiceModelBehavior(ITextRenderer<? super T> renderer) {
        this(renderer, null);
    }

    public ChoiceModelBehavior(ITextRenderer<? super T> renderer, IJQueryTemplate template) {
        this.renderer = renderer;
        this.template = template;
    }

    protected List<String> getProperties() {
        if (this.template != null) {
            return ListUtils.exclude(this.template.getTextProperties(), this.renderer.getFields());
        }
        return Collections.emptyList();
    }

    @Override
    protected String getResponse(IRequestParameters parameters) {
        StringBuilder builder = new StringBuilder("[");
        List choices = this.getChoices();
        if (choices != null) {
            int index = 0;
            for (Object choice : choices) {
                if (index++ > 0) {
                    builder.append(", ");
                }
                builder.append("{ ");
                builder.append(this.renderer.render(choice));
                List<String> properties = this.getProperties();
                for (String property : properties) {
                    builder.append(", ");
                    BuilderUtils.append(builder, property, this.renderer.getText(choice, property));
                }
                builder.append(" }");
            }
        }
        return builder.append("]").toString();
    }
}

