/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.Iterables;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.reparent.Attribute;
import com.google.gxp.compiler.schema.DocType;
import com.google.gxp.compiler.schema.ElementValidator;
import com.google.gxp.compiler.schema.Schema;
import java.util.List;

public class OutputElement
extends Expression {
    private final Schema innerSchema;
    private final String localName;
    private final ElementValidator validator;
    private final DocType docType;
    private final ImmutableList<Attribute> attributes;
    private final ImmutableList<String> attrBundles;
    private final String phName;
    private final Expression content;

    public OutputElement(SourcePosition sourcePosition, String displayName, Schema schema, Schema innerSchema, String localName, ElementValidator validator, DocType docType, List<Attribute> attributes, List<String> attrBundles, String phName, Expression content) {
        super(sourcePosition, displayName, schema);
        this.innerSchema = innerSchema;
        this.localName = Preconditions.checkNotNull(localName);
        this.validator = Preconditions.checkNotNull(validator);
        this.docType = docType;
        this.attributes = ImmutableList.copyOf(attributes);
        this.attrBundles = ImmutableList.copyOf(attrBundles);
        this.phName = phName;
        this.content = Preconditions.checkNotNull(content);
    }

    public OutputElement(OutputElement fromNode, List<Attribute> attributes, Expression content) {
        this(fromNode.getSourcePosition(), fromNode.getDisplayName(), fromNode.getSchema(), fromNode.getInnerSchema(), fromNode.getLocalName(), fromNode.getValidator(), fromNode.getDocType(), attributes, fromNode.getAttrBundles(), fromNode.getPhName(), content);
    }

    public Schema getInnerSchema() {
        return this.innerSchema;
    }

    public String getLocalName() {
        return this.localName;
    }

    public ElementValidator getValidator() {
        return this.validator;
    }

    public DocType getDocType() {
        return this.docType;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public List<String> getAttrBundles() {
        return this.attrBundles;
    }

    public String getPhName() {
        return this.phName;
    }

    public Expression getContent() {
        return this.content;
    }

    public OutputElement withAttributesAndContent(List<Attribute> newAttributes, Expression newContent) {
        return Iterables.elementsEqual(newAttributes, this.attributes) && newContent.equals(this.content) ? this : new OutputElement(this, newAttributes, newContent);
    }

    @Override
    public <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitOutputElement(this);
    }

    @Override
    public boolean hasStaticString() {
        for (Attribute attribute : this.getAttributes()) {
            if (attribute.getCondition() == null && attribute.getValue().hasStaticString()) continue;
            return false;
        }
        return this.getContent().hasStaticString();
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof OutputElement && this.equals((OutputElement)that);
    }

    public boolean equals(OutputElement that) {
        return this.equalsExpression(that) && Objects.equal(this.innerSchema, that.innerSchema) && this.localName.equals(that.localName) && this.validator.equals((Object)that.validator) && Objects.equal(this.docType, that.docType) && Iterables.elementsEqual(this.attributes, that.attributes) && Iterables.elementsEqual(this.attrBundles, that.attrBundles) && Objects.equal(this.phName, that.phName) && this.content.equals(that.content);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.expressionHashCode(), this.innerSchema, this.localName, this.validator, this.docType, this.attributes, this.attrBundles, this.phName, this.content);
    }
}

