/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptException;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.core.client.JsArrayString;

public class StackTraceCreator {
    public static void createStackTrace(JavaScriptException e) {
        if (!GWT.isScript()) {
            throw new RuntimeException("StackTraceCreator should only be called in web mode");
        }
        ((Collector)GWT.create(Collector.class)).createStackTrace(e);
    }

    public static void fillInStackTrace(Throwable t) {
        if (!GWT.isScript()) {
            throw new RuntimeException("StackTraceCreator should only be called in web mode");
        }
        ((Collector)GWT.create(Collector.class)).fillInStackTrace(t);
    }

    static JsArrayString createStackTrace() {
        if (!GWT.isScript()) {
            throw new RuntimeException("StackTraceCreator should only be called in web mode");
        }
        return ((Collector)GWT.create(Collector.class)).collect();
    }

    static String extractNameFromToString(String fnToString) {
        String toReturn = "";
        int index = (fnToString = fnToString.trim()).indexOf("(");
        if (index != -1) {
            int start = fnToString.startsWith("function") ? 8 : 0;
            toReturn = fnToString.substring(start, index).trim();
        }
        return toReturn.length() > 0 ? toReturn : "anonymous";
    }

    private static native JsArrayString splice(JsArrayString var0, int var1);

    static class CollectorOpera
    extends CollectorMoz {
        CollectorOpera() {
        }

        protected String extractName(String fnToString) {
            return fnToString.length() == 0 ? "anonymous" : fnToString;
        }

        protected JsArrayString getStack(JavaScriptObject e) {
            JsArrayString toReturn = this.getMessage(e);
            assert (toReturn.length() % 2 == 0) : "Expecting an even number of lines";
            int i = 0;
            int j = toReturn.length();
            for (int i2 = 0; i2 < j; i2 += 2) {
                int idx = toReturn.get(i2).lastIndexOf("function ");
                if (idx == -1) {
                    toReturn.set(i, "");
                } else {
                    toReturn.set(i, toReturn.get(i2).substring(idx + 9).trim());
                }
                ++i;
            }
            this.setLength(toReturn, i);
            return toReturn;
        }

        protected int toSplice() {
            return 3;
        }

        private native JsArrayString getMessage(JavaScriptObject var1);

        private native void setLength(JsArrayString var1, int var2);
    }

    static class CollectorChrome
    extends CollectorMoz {
        CollectorChrome() {
        }

        public JsArrayString collect() {
            JsArrayString res = super.collect();
            if (res.length() == 0) {
                res = StackTraceCreator.splice(new Collector().collect(), 1);
            }
            return res;
        }

        public JsArrayString inferFrom(JavaScriptObject e) {
            JsArrayString stack = super.inferFrom(e);
            if (stack.length() == 0) {
                return new Collector().inferFrom(e);
            }
            return StackTraceCreator.splice(stack, 1);
        }

        protected String extractName(String fnToString) {
            int index;
            if (fnToString.length() == 0) {
                return "anonymous";
            }
            String toReturn = fnToString.trim();
            if (toReturn.startsWith("at ")) {
                toReturn = toReturn.substring(3);
            }
            if ((index = toReturn.indexOf("[")) == -1) {
                index = toReturn.indexOf("(");
            }
            if (index == -1) {
                return "anonymous";
            }
            if ((index = (toReturn = toReturn.substring(0, index).trim()).indexOf(46)) != -1) {
                toReturn = toReturn.substring(index + 1);
            }
            return toReturn.length() > 0 ? toReturn : "anonymous";
        }

        protected int toSplice() {
            return 3;
        }
    }

    static class CollectorMoz
    extends Collector {
        CollectorMoz() {
        }

        public JsArrayString collect() {
            return StackTraceCreator.splice(this.inferFrom(this.makeException()), this.toSplice());
        }

        public JsArrayString inferFrom(JavaScriptObject e) {
            JsArrayString stack = this.getStack(e);
            int j = stack.length();
            for (int i = 0; i < j; ++i) {
                stack.set(i, this.extractName(stack.get(i)));
            }
            return stack;
        }

        protected native JsArrayString getStack(JavaScriptObject var1);

        protected int toSplice() {
            return 2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CollectorEmulated
    extends Collector {
        CollectorEmulated() {
        }

        @Override
        public JsArrayString collect() {
            JsArrayString toReturn = (JsArrayString)JsArrayString.createArray().cast();
            JsArray<JavaScriptObject> stack = this.getStack();
            int j = this.getStackDepth();
            for (int i = 0; i < j; ++i) {
                String name = stack.get(i) == null ? "anonymous" : this.extractName(stack.get(i).toString());
                toReturn.set(j - i - 1, name);
            }
            return toReturn;
        }

        @Override
        public void createStackTrace(JavaScriptException e) {
        }

        @Override
        public void fillInStackTrace(Throwable t) {
            JsArrayString stack = this.collect();
            JsArrayString locations = this.getLocation();
            StackTraceElement[] stackTrace = new StackTraceElement[stack.length()];
            int j = stackTrace.length;
            for (int i = 0; i < j; ++i) {
                String location = locations.get(j - i - 1);
                String fileName = "Unknown source";
                int lineNumber = 0;
                if (location != null) {
                    int idx = location.indexOf(58);
                    if (idx != -1) {
                        fileName = location.substring(0, idx);
                        lineNumber = Integer.parseInt(location.substring(idx + 1));
                    } else {
                        lineNumber = Integer.parseInt(location);
                    }
                }
                stackTrace[i] = new StackTraceElement("Unknown", stack.get(i), fileName, lineNumber);
            }
            t.setStackTrace(stackTrace);
        }

        @Override
        public JsArrayString inferFrom(JavaScriptObject e) {
            throw new RuntimeException("Should not reach here");
        }

        private native JsArrayString getLocation();

        private native JsArray<JavaScriptObject> getStack();

        private native int getStackDepth();
    }

    static class Collector {
        Collector() {
        }

        public native JsArrayString collect();

        public void createStackTrace(JavaScriptException e) {
            JsArrayString stack = this.inferFrom(e.getException());
            StackTraceElement[] stackTrace = new StackTraceElement[stack.length()];
            int j = stackTrace.length;
            for (int i = 0; i < j; ++i) {
                stackTrace[i] = new StackTraceElement("Unknown", stack.get(i), "Unknown source", 0);
            }
            e.setStackTrace(stackTrace);
        }

        public void fillInStackTrace(Throwable t) {
            JsArrayString stack = StackTraceCreator.createStackTrace();
            StackTraceElement[] stackTrace = new StackTraceElement[stack.length()];
            int j = stackTrace.length;
            for (int i = 0; i < j; ++i) {
                stackTrace[i] = new StackTraceElement("Unknown", stack.get(i), "Unknown source", 0);
            }
            t.setStackTrace(stackTrace);
        }

        public JsArrayString inferFrom(JavaScriptObject e) {
            return (JsArrayString)JavaScriptObject.createArray().cast();
        }

        protected String extractName(String fnToString) {
            return StackTraceCreator.extractNameFromToString(fnToString);
        }

        protected native JavaScriptObject makeException();
    }
}

