/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.secretmanager;

import com.google.api.gax.rpc.NotFoundException;
import com.google.cloud.secretmanager.v1.AddSecretVersionRequest;
import com.google.cloud.secretmanager.v1.CreateSecretRequest;
import com.google.cloud.secretmanager.v1.DeleteSecretRequest;
import com.google.cloud.secretmanager.v1.LocationName;
import com.google.cloud.secretmanager.v1.ProjectName;
import com.google.cloud.secretmanager.v1.Replication;
import com.google.cloud.secretmanager.v1.Secret;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretName;
import com.google.cloud.secretmanager.v1.SecretPayload;
import com.google.cloud.secretmanager.v1.SecretVersionName;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.secretmanager.SecretManagerOperations;
import com.google.cloud.spring.secretmanager.SecretManagerPropertyUtils;
import com.google.cloud.spring.secretmanager.SecretManagerServiceClientFactory;
import com.google.protobuf.ByteString;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class SecretManagerTemplate
implements SecretManagerOperations {
    public static final String LATEST_VERSION = "latest";
    public static final String GLOBAL_LOCATION = "global";
    private static final Log LOGGER = LogFactory.getLog(SecretManagerTemplate.class);
    private final SecretManagerServiceClient secretManagerServiceClient;
    private final SecretManagerServiceClientFactory clientFactory;
    private final GcpProjectIdProvider projectIdProvider;
    private boolean allowDefaultSecretValue;

    public SecretManagerTemplate(SecretManagerServiceClient secretManagerServiceClient, GcpProjectIdProvider projectIdProvider) {
        this(secretManagerServiceClient, null, projectIdProvider);
    }

    public SecretManagerTemplate(SecretManagerServiceClientFactory clientFactory, GcpProjectIdProvider projectIdProvider) {
        this(clientFactory.getClient(GLOBAL_LOCATION), clientFactory, projectIdProvider);
    }

    private SecretManagerTemplate(SecretManagerServiceClient secretManagerServiceClient, SecretManagerServiceClientFactory clientFactory, GcpProjectIdProvider projectIdProvider) {
        this.secretManagerServiceClient = secretManagerServiceClient;
        this.clientFactory = clientFactory;
        this.projectIdProvider = projectIdProvider;
        this.allowDefaultSecretValue = false;
    }

    private SecretManagerServiceClient getClient(@Nullable String locationId) {
        return this.clientFactory == null ? this.secretManagerServiceClient : this.clientFactory.getClient(locationId);
    }

    public SecretManagerTemplate setAllowDefaultSecretValue(boolean allowDefaultSecretValue) {
        this.allowDefaultSecretValue = allowDefaultSecretValue;
        return this;
    }

    public String getProjectId() {
        return this.projectIdProvider.getProjectId();
    }

    @Override
    public void createSecret(String secretId, String payload) {
        this.createNewSecretVersion(secretId, ByteString.copyFromUtf8((String)payload), this.projectIdProvider.getProjectId(), null);
    }

    @Override
    public void createSecret(String secretId, String payload, String locationId) {
        this.createNewSecretVersion(secretId, ByteString.copyFromUtf8((String)payload), this.projectIdProvider.getProjectId(), locationId);
    }

    @Override
    public void createSecret(String secretId, byte[] payload) {
        this.createNewSecretVersion(secretId, ByteString.copyFrom((byte[])payload), this.projectIdProvider.getProjectId(), null);
    }

    @Override
    public void createSecret(String secretId, byte[] payload, String projectId) {
        this.createNewSecretVersion(secretId, ByteString.copyFrom((byte[])payload), projectId, null);
    }

    @Override
    public void createSecret(String secretId, byte[] payload, String projectId, String locationId) {
        this.createNewSecretVersion(secretId, ByteString.copyFrom((byte[])payload), projectId, locationId);
    }

    @Override
    @Nullable
    public String getSecretString(String secretIdentifier) {
        ByteString secretByteString = this.getSecretByteString(secretIdentifier);
        return secretByteString == null ? null : secretByteString.toStringUtf8();
    }

    @Override
    @Nullable
    public byte[] getSecretBytes(String secretIdentifier) {
        ByteString secretByteString = this.getSecretByteString(secretIdentifier);
        return secretByteString == null ? null : secretByteString.toByteArray();
    }

    @Override
    public boolean secretExists(String secretId) {
        return this.secretExists(secretId, this.projectIdProvider.getProjectId());
    }

    @Override
    public boolean secretExists(String secretId, String projectId) {
        SecretName secretName = this.getSecretName(projectId, secretId, null);
        try {
            this.getClient(GLOBAL_LOCATION).getSecret(secretName);
        }
        catch (NotFoundException ex) {
            return false;
        }
        return true;
    }

    @Override
    public boolean secretExists(String secretId, String projectId, String locationId) {
        SecretName secretName = this.getSecretName(projectId, secretId, locationId);
        try {
            this.getClient(locationId).getSecret(secretName);
        }
        catch (NotFoundException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void disableSecretVersion(String secretId, String version) {
        this.disableSecretVersion(secretId, version, this.projectIdProvider.getProjectId());
    }

    @Override
    public void disableSecretVersion(String secretId, String version, String projectId) {
        SecretVersionName secretVersionName = SecretManagerPropertyUtils.getSecretVersionName(projectId, secretId, version, null);
        this.getClient(GLOBAL_LOCATION).disableSecretVersion(secretVersionName);
    }

    @Override
    public void disableSecretVersion(String secretId, String version, String projectId, String locationId) {
        SecretVersionName secretVersionName = SecretManagerPropertyUtils.getSecretVersionName(projectId, secretId, version, locationId);
        this.getClient(locationId).disableSecretVersion(secretVersionName);
    }

    @Override
    public void enableSecretVersion(String secretId, String version) {
        this.enableSecretVersion(secretId, version, this.projectIdProvider.getProjectId());
    }

    @Override
    public void enableSecretVersion(String secretId, String version, String projectId) {
        SecretVersionName secretVersionName = SecretManagerPropertyUtils.getSecretVersionName(projectId, secretId, version, null);
        this.getClient(GLOBAL_LOCATION).enableSecretVersion(secretVersionName);
    }

    @Override
    public void enableSecretVersion(String secretId, String version, String projectId, String locationId) {
        SecretVersionName secretVersionName = SecretManagerPropertyUtils.getSecretVersionName(projectId, secretId, version, locationId);
        this.getClient(locationId).enableSecretVersion(secretVersionName);
    }

    @Override
    public void deleteSecret(String secretId) {
        this.deleteSecret(secretId, this.projectIdProvider.getProjectId());
    }

    @Override
    public void deleteSecret(String secretId, String projectId) {
        SecretName name = this.getSecretName(projectId, secretId, null);
        DeleteSecretRequest request = DeleteSecretRequest.newBuilder().setName(name.toString()).build();
        this.getClient(GLOBAL_LOCATION).deleteSecret(request);
    }

    @Override
    public void deleteSecret(String secretId, String projectId, String locationId) {
        SecretName name = this.getSecretName(projectId, secretId, locationId);
        DeleteSecretRequest request = DeleteSecretRequest.newBuilder().setName(name.toString()).build();
        this.getClient(locationId).deleteSecret(request);
    }

    @Override
    public void deleteSecretVersion(String secretId, String version, String projectId) {
        SecretVersionName secretVersionName = SecretManagerPropertyUtils.getSecretVersionName(projectId, secretId, version, null);
        this.getClient(GLOBAL_LOCATION).destroySecretVersion(secretVersionName);
    }

    @Override
    public void deleteSecretVersion(String secretId, String version, String projectId, String locationId) {
        SecretVersionName secretVersionName = SecretManagerPropertyUtils.getSecretVersionName(projectId, secretId, version, locationId);
        this.getClient(locationId).destroySecretVersion(secretVersionName);
    }

    ByteString getSecretByteString(String secretIdentifier) {
        SecretVersionName secretVersionName = SecretManagerPropertyUtils.getSecretVersionName(secretIdentifier, this.projectIdProvider);
        if (secretVersionName == null) {
            secretVersionName = this.getDefaultSecretVersionName(secretIdentifier);
        }
        return this.getSecretByteString(secretVersionName);
    }

    ByteString getSecretByteString(SecretVersionName secretVersionName) {
        ByteString secretData;
        try {
            secretData = this.getClient(secretVersionName.getLocation()).accessSecretVersion(secretVersionName).getPayload().getData();
        }
        catch (NotFoundException ex) {
            LOGGER.warn((Object)(secretVersionName.toString() + " doesn't exist in Secret Manager."));
            if (!this.allowDefaultSecretValue) {
                throw ex;
            }
            return null;
        }
        return secretData;
    }

    private void createNewSecretVersion(String secretId, ByteString payload, String projectId, String locationId) {
        if (!this.secretExists(secretId, projectId, locationId)) {
            this.createSecretInternal(secretId, projectId, locationId);
        }
        SecretName name = this.getSecretName(projectId, secretId, locationId);
        AddSecretVersionRequest payloadRequest = AddSecretVersionRequest.newBuilder().setParent(name.toString()).setPayload(SecretPayload.newBuilder().setData(payload)).build();
        this.getClient(locationId).addSecretVersion(payloadRequest);
    }

    private void createSecretInternal(String secretId, String projectId, String locationId) {
        String parent;
        Secret.Builder secret = Secret.newBuilder();
        if (ObjectUtils.isEmpty((Object)locationId)) {
            secret.setReplication(Replication.newBuilder().setAutomatic(Replication.Automatic.getDefaultInstance()));
            parent = ProjectName.of((String)projectId).toString();
        } else {
            parent = LocationName.of((String)projectId, (String)locationId).toString();
        }
        CreateSecretRequest request = CreateSecretRequest.newBuilder().setParent(parent).setSecretId(secretId).setSecret(secret.build()).build();
        this.getClient(locationId).createSecret(request);
    }

    private SecretVersionName getDefaultSecretVersionName(String secretId) {
        return SecretManagerPropertyUtils.getSecretVersionName(this.projectIdProvider.getProjectId(), secretId, LATEST_VERSION, null);
    }

    private SecretName getSecretName(String projectId, String secretId, String locationId) {
        if (ObjectUtils.isEmpty((Object)locationId)) {
            return SecretName.of((String)projectId, (String)secretId);
        }
        return SecretName.ofProjectLocationSecretName((String)projectId, (String)locationId, (String)secretId);
    }
}

