/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.core;

import com.google.api.gax.rpc.HeaderProvider;
import java.util.Collections;
import java.util.Map;

public class UserAgentHeaderProvider
implements HeaderProvider {
    private String userAgent;
    private final Map<String, String> headers;

    public UserAgentHeaderProvider(Class<?> clazz) {
        this.userAgent = this.computeUserAgent(clazz);
        this.headers = Collections.singletonMap("user-agent", this.userAgent);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    private String computeUserAgent(Class<?> clazz) {
        String[] packageTokens = clazz.getPackage().getName().split("\\.");
        String springLibrary = "spring-cloud-gcp-" + packageTokens[packageTokens.length - 1];
        String version = this.getClass().getPackage().getImplementationVersion();
        return "Spring/" + version + " " + springLibrary + "/" + version;
    }
}

