/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.http.impl.io;

import com.google.appengine.repackaged.org.apache.http.HttpException;
import com.google.appengine.repackaged.org.apache.http.HttpResponse;
import com.google.appengine.repackaged.org.apache.http.HttpResponseFactory;
import com.google.appengine.repackaged.org.apache.http.NoHttpResponseException;
import com.google.appengine.repackaged.org.apache.http.ParseException;
import com.google.appengine.repackaged.org.apache.http.StatusLine;
import com.google.appengine.repackaged.org.apache.http.annotation.NotThreadSafe;
import com.google.appengine.repackaged.org.apache.http.impl.io.AbstractMessageParser;
import com.google.appengine.repackaged.org.apache.http.io.SessionInputBuffer;
import com.google.appengine.repackaged.org.apache.http.message.LineParser;
import com.google.appengine.repackaged.org.apache.http.message.ParserCursor;
import com.google.appengine.repackaged.org.apache.http.params.HttpParams;
import com.google.appengine.repackaged.org.apache.http.util.CharArrayBuffer;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class DefaultHttpResponseParser
extends AbstractMessageParser<HttpResponse> {
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;

    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser parser, HttpResponseFactory responseFactory, HttpParams params) {
        super(buffer, parser, params);
        if (responseFactory == null) {
            throw new IllegalArgumentException("Response factory may not be null");
        }
        this.responseFactory = responseFactory;
        this.lineBuf = new CharArrayBuffer(128);
    }

    @Override
    protected HttpResponse parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int i = sessionBuffer.readLine(this.lineBuf);
        if (i == -1) {
            throw new NoHttpResponseException("The target server failed to respond");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }
}

