/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2018-10-25 at 08:23:19 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * Metric filter to be used in a segment filter clause.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SegmentMetricFilter extends com.google.api.client.json.GenericJson {

  /**
   * The value to compare against. If the operator is `BETWEEN`, this value is treated as minimum
   * comparison value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String comparisonValue;

  /**
   * Max comparison value is only used for `BETWEEN` operator.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String maxComparisonValue;

  /**
   * The metric that will be filtered on. A `metricFilter` must contain a metric name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String metricName;

  /**
   * Specifies is the operation to perform to compare the metric. The default is `EQUAL`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String operator;

  /**
   * Scope for a metric defines the level at which that metric is defined.  The specified metric
   * scope must be equal to or greater than its primary scope as defined in the data model. The
   * primary scope is defined by if the segment is selecting users or sessions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String scope;

  /**
   * The value to compare against. If the operator is `BETWEEN`, this value is treated as minimum
   * comparison value.
   * @return value or {@code null} for none
   */
  public java.lang.String getComparisonValue() {
    return comparisonValue;
  }

  /**
   * The value to compare against. If the operator is `BETWEEN`, this value is treated as minimum
   * comparison value.
   * @param comparisonValue comparisonValue or {@code null} for none
   */
  public SegmentMetricFilter setComparisonValue(java.lang.String comparisonValue) {
    this.comparisonValue = comparisonValue;
    return this;
  }

  /**
   * Max comparison value is only used for `BETWEEN` operator.
   * @return value or {@code null} for none
   */
  public java.lang.String getMaxComparisonValue() {
    return maxComparisonValue;
  }

  /**
   * Max comparison value is only used for `BETWEEN` operator.
   * @param maxComparisonValue maxComparisonValue or {@code null} for none
   */
  public SegmentMetricFilter setMaxComparisonValue(java.lang.String maxComparisonValue) {
    this.maxComparisonValue = maxComparisonValue;
    return this;
  }

  /**
   * The metric that will be filtered on. A `metricFilter` must contain a metric name.
   * @return value or {@code null} for none
   */
  public java.lang.String getMetricName() {
    return metricName;
  }

  /**
   * The metric that will be filtered on. A `metricFilter` must contain a metric name.
   * @param metricName metricName or {@code null} for none
   */
  public SegmentMetricFilter setMetricName(java.lang.String metricName) {
    this.metricName = metricName;
    return this;
  }

  /**
   * Specifies is the operation to perform to compare the metric. The default is `EQUAL`.
   * @return value or {@code null} for none
   */
  public java.lang.String getOperator() {
    return operator;
  }

  /**
   * Specifies is the operation to perform to compare the metric. The default is `EQUAL`.
   * @param operator operator or {@code null} for none
   */
  public SegmentMetricFilter setOperator(java.lang.String operator) {
    this.operator = operator;
    return this;
  }

  /**
   * Scope for a metric defines the level at which that metric is defined.  The specified metric
   * scope must be equal to or greater than its primary scope as defined in the data model. The
   * primary scope is defined by if the segment is selecting users or sessions.
   * @return value or {@code null} for none
   */
  public java.lang.String getScope() {
    return scope;
  }

  /**
   * Scope for a metric defines the level at which that metric is defined.  The specified metric
   * scope must be equal to or greater than its primary scope as defined in the data model. The
   * primary scope is defined by if the segment is selecting users or sessions.
   * @param scope scope or {@code null} for none
   */
  public SegmentMetricFilter setScope(java.lang.String scope) {
    this.scope = scope;
    return this;
  }

  @Override
  public SegmentMetricFilter set(String fieldName, Object value) {
    return (SegmentMetricFilter) super.set(fieldName, value);
  }

  @Override
  public SegmentMetricFilter clone() {
    return (SegmentMetricFilter) super.clone();
  }

}
