/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2018-10-25 at 08:23:19 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * Dimension filter specifies the filtering options on a dimension.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DimensionFilter extends com.google.api.client.json.GenericJson {

  /**
   * Should the match be case sensitive? Default is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean caseSensitive;

  /**
   * The dimension to filter on. A DimensionFilter must contain a dimension.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dimensionName;

  /**
   * Strings or regular expression to match against. Only the first value of the list is used for
   * comparison unless the operator is `IN_LIST`. If `IN_LIST` operator, then the entire list is
   * used to filter the dimensions as explained in the description of the `IN_LIST` operator.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> expressions;

  /**
   * Logical `NOT` operator. If this boolean is set to true, then the matching dimension values will
   * be excluded in the report. The default is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean not;

  /**
   * How to match the dimension to the expression. The default is REGEXP.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String operator;

  /**
   * Should the match be case sensitive? Default is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCaseSensitive() {
    return caseSensitive;
  }

  /**
   * Should the match be case sensitive? Default is false.
   * @param caseSensitive caseSensitive or {@code null} for none
   */
  public DimensionFilter setCaseSensitive(java.lang.Boolean caseSensitive) {
    this.caseSensitive = caseSensitive;
    return this;
  }

  /**
   * The dimension to filter on. A DimensionFilter must contain a dimension.
   * @return value or {@code null} for none
   */
  public java.lang.String getDimensionName() {
    return dimensionName;
  }

  /**
   * The dimension to filter on. A DimensionFilter must contain a dimension.
   * @param dimensionName dimensionName or {@code null} for none
   */
  public DimensionFilter setDimensionName(java.lang.String dimensionName) {
    this.dimensionName = dimensionName;
    return this;
  }

  /**
   * Strings or regular expression to match against. Only the first value of the list is used for
   * comparison unless the operator is `IN_LIST`. If `IN_LIST` operator, then the entire list is
   * used to filter the dimensions as explained in the description of the `IN_LIST` operator.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getExpressions() {
    return expressions;
  }

  /**
   * Strings or regular expression to match against. Only the first value of the list is used for
   * comparison unless the operator is `IN_LIST`. If `IN_LIST` operator, then the entire list is
   * used to filter the dimensions as explained in the description of the `IN_LIST` operator.
   * @param expressions expressions or {@code null} for none
   */
  public DimensionFilter setExpressions(java.util.List<java.lang.String> expressions) {
    this.expressions = expressions;
    return this;
  }

  /**
   * Logical `NOT` operator. If this boolean is set to true, then the matching dimension values will
   * be excluded in the report. The default is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getNot() {
    return not;
  }

  /**
   * Logical `NOT` operator. If this boolean is set to true, then the matching dimension values will
   * be excluded in the report. The default is false.
   * @param not not or {@code null} for none
   */
  public DimensionFilter setNot(java.lang.Boolean not) {
    this.not = not;
    return this;
  }

  /**
   * How to match the dimension to the expression. The default is REGEXP.
   * @return value or {@code null} for none
   */
  public java.lang.String getOperator() {
    return operator;
  }

  /**
   * How to match the dimension to the expression. The default is REGEXP.
   * @param operator operator or {@code null} for none
   */
  public DimensionFilter setOperator(java.lang.String operator) {
    this.operator = operator;
    return this;
  }

  @Override
  public DimensionFilter set(String fieldName, Object value) {
    return (DimensionFilter) super.set(fieldName, value);
  }

  @Override
  public DimensionFilter clone() {
    return (DimensionFilter) super.clone();
  }

}
