/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/batch/v1/task.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.batch.v1;

public interface TaskSpecOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.batch.v1.TaskSpec)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The sequence of one or more runnables (executable scripts,
   * executable containers, and/or barriers) for each task in this task group to
   * run. Each task runs this list of runnables in order. For a task to succeed,
   * all of its script and container runnables each must meet at least one of
   * the following conditions:
   *
   * + The runnable exited with a zero status.
   * + The runnable didn't finish, but you enabled its `background` subfield.
   * + The runnable exited with a non-zero status, but you enabled its
   *   `ignore_exit_status` subfield.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
   */
  java.util.List<com.google.cloud.batch.v1.Runnable> getRunnablesList();

  /**
   *
   *
   * <pre>
   * Required. The sequence of one or more runnables (executable scripts,
   * executable containers, and/or barriers) for each task in this task group to
   * run. Each task runs this list of runnables in order. For a task to succeed,
   * all of its script and container runnables each must meet at least one of
   * the following conditions:
   *
   * + The runnable exited with a zero status.
   * + The runnable didn't finish, but you enabled its `background` subfield.
   * + The runnable exited with a non-zero status, but you enabled its
   *   `ignore_exit_status` subfield.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
   */
  com.google.cloud.batch.v1.Runnable getRunnables(int index);

  /**
   *
   *
   * <pre>
   * Required. The sequence of one or more runnables (executable scripts,
   * executable containers, and/or barriers) for each task in this task group to
   * run. Each task runs this list of runnables in order. For a task to succeed,
   * all of its script and container runnables each must meet at least one of
   * the following conditions:
   *
   * + The runnable exited with a zero status.
   * + The runnable didn't finish, but you enabled its `background` subfield.
   * + The runnable exited with a non-zero status, but you enabled its
   *   `ignore_exit_status` subfield.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
   */
  int getRunnablesCount();

  /**
   *
   *
   * <pre>
   * Required. The sequence of one or more runnables (executable scripts,
   * executable containers, and/or barriers) for each task in this task group to
   * run. Each task runs this list of runnables in order. For a task to succeed,
   * all of its script and container runnables each must meet at least one of
   * the following conditions:
   *
   * + The runnable exited with a zero status.
   * + The runnable didn't finish, but you enabled its `background` subfield.
   * + The runnable exited with a non-zero status, but you enabled its
   *   `ignore_exit_status` subfield.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
   */
  java.util.List<? extends com.google.cloud.batch.v1.RunnableOrBuilder> getRunnablesOrBuilderList();

  /**
   *
   *
   * <pre>
   * Required. The sequence of one or more runnables (executable scripts,
   * executable containers, and/or barriers) for each task in this task group to
   * run. Each task runs this list of runnables in order. For a task to succeed,
   * all of its script and container runnables each must meet at least one of
   * the following conditions:
   *
   * + The runnable exited with a zero status.
   * + The runnable didn't finish, but you enabled its `background` subfield.
   * + The runnable exited with a non-zero status, but you enabled its
   *   `ignore_exit_status` subfield.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
   */
  com.google.cloud.batch.v1.RunnableOrBuilder getRunnablesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * ComputeResource requirements.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.ComputeResource compute_resource = 3;</code>
   *
   * @return Whether the computeResource field is set.
   */
  boolean hasComputeResource();

  /**
   *
   *
   * <pre>
   * ComputeResource requirements.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.ComputeResource compute_resource = 3;</code>
   *
   * @return The computeResource.
   */
  com.google.cloud.batch.v1.ComputeResource getComputeResource();

  /**
   *
   *
   * <pre>
   * ComputeResource requirements.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.ComputeResource compute_resource = 3;</code>
   */
  com.google.cloud.batch.v1.ComputeResourceOrBuilder getComputeResourceOrBuilder();

  /**
   *
   *
   * <pre>
   * Maximum duration the task should run before being automatically retried
   * (if enabled) or automatically failed. Format the value of this field
   * as a time limit in seconds followed by `s`&amp;mdash;for example, `3600s`
   * for 1 hour. The field accepts any value between 0 and the maximum listed
   * for the `Duration` field type at
   * https://protobuf.dev/reference/protobuf/google.protobuf/#duration; however,
   * the actual maximum run time for a job will be limited to the maximum run
   * time for a job listed at
   * https://cloud.google.com/batch/quotas#max-job-duration.
   * </pre>
   *
   * <code>.google.protobuf.Duration max_run_duration = 4;</code>
   *
   * @return Whether the maxRunDuration field is set.
   */
  boolean hasMaxRunDuration();

  /**
   *
   *
   * <pre>
   * Maximum duration the task should run before being automatically retried
   * (if enabled) or automatically failed. Format the value of this field
   * as a time limit in seconds followed by `s`&amp;mdash;for example, `3600s`
   * for 1 hour. The field accepts any value between 0 and the maximum listed
   * for the `Duration` field type at
   * https://protobuf.dev/reference/protobuf/google.protobuf/#duration; however,
   * the actual maximum run time for a job will be limited to the maximum run
   * time for a job listed at
   * https://cloud.google.com/batch/quotas#max-job-duration.
   * </pre>
   *
   * <code>.google.protobuf.Duration max_run_duration = 4;</code>
   *
   * @return The maxRunDuration.
   */
  com.google.protobuf.Duration getMaxRunDuration();

  /**
   *
   *
   * <pre>
   * Maximum duration the task should run before being automatically retried
   * (if enabled) or automatically failed. Format the value of this field
   * as a time limit in seconds followed by `s`&amp;mdash;for example, `3600s`
   * for 1 hour. The field accepts any value between 0 and the maximum listed
   * for the `Duration` field type at
   * https://protobuf.dev/reference/protobuf/google.protobuf/#duration; however,
   * the actual maximum run time for a job will be limited to the maximum run
   * time for a job listed at
   * https://cloud.google.com/batch/quotas#max-job-duration.
   * </pre>
   *
   * <code>.google.protobuf.Duration max_run_duration = 4;</code>
   */
  com.google.protobuf.DurationOrBuilder getMaxRunDurationOrBuilder();

  /**
   *
   *
   * <pre>
   * Maximum number of retries on failures.
   * The default, 0, which means never retry.
   * The valid value range is [0, 10].
   * </pre>
   *
   * <code>int32 max_retry_count = 5;</code>
   *
   * @return The maxRetryCount.
   */
  int getMaxRetryCount();

  /**
   *
   *
   * <pre>
   * Lifecycle management schema when any task in a task group is failed.
   * Currently we only support one lifecycle policy.
   * When the lifecycle policy condition is met,
   * the action in the policy will execute.
   * If task execution result does not meet with the defined lifecycle
   * policy, we consider it as the default policy.
   * Default policy means if the exit code is 0, exit task.
   * If task ends with non-zero exit code, retry the task with max_retry_count.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
   */
  java.util.List<com.google.cloud.batch.v1.LifecyclePolicy> getLifecyclePoliciesList();

  /**
   *
   *
   * <pre>
   * Lifecycle management schema when any task in a task group is failed.
   * Currently we only support one lifecycle policy.
   * When the lifecycle policy condition is met,
   * the action in the policy will execute.
   * If task execution result does not meet with the defined lifecycle
   * policy, we consider it as the default policy.
   * Default policy means if the exit code is 0, exit task.
   * If task ends with non-zero exit code, retry the task with max_retry_count.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
   */
  com.google.cloud.batch.v1.LifecyclePolicy getLifecyclePolicies(int index);

  /**
   *
   *
   * <pre>
   * Lifecycle management schema when any task in a task group is failed.
   * Currently we only support one lifecycle policy.
   * When the lifecycle policy condition is met,
   * the action in the policy will execute.
   * If task execution result does not meet with the defined lifecycle
   * policy, we consider it as the default policy.
   * Default policy means if the exit code is 0, exit task.
   * If task ends with non-zero exit code, retry the task with max_retry_count.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
   */
  int getLifecyclePoliciesCount();

  /**
   *
   *
   * <pre>
   * Lifecycle management schema when any task in a task group is failed.
   * Currently we only support one lifecycle policy.
   * When the lifecycle policy condition is met,
   * the action in the policy will execute.
   * If task execution result does not meet with the defined lifecycle
   * policy, we consider it as the default policy.
   * Default policy means if the exit code is 0, exit task.
   * If task ends with non-zero exit code, retry the task with max_retry_count.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
   */
  java.util.List<? extends com.google.cloud.batch.v1.LifecyclePolicyOrBuilder>
      getLifecyclePoliciesOrBuilderList();

  /**
   *
   *
   * <pre>
   * Lifecycle management schema when any task in a task group is failed.
   * Currently we only support one lifecycle policy.
   * When the lifecycle policy condition is met,
   * the action in the policy will execute.
   * If task execution result does not meet with the defined lifecycle
   * policy, we consider it as the default policy.
   * Default policy means if the exit code is 0, exit task.
   * If task ends with non-zero exit code, retry the task with max_retry_count.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
   */
  com.google.cloud.batch.v1.LifecyclePolicyOrBuilder getLifecyclePoliciesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Deprecated: please use environment(non-plural) instead.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environments = 6 [deprecated = true];</code>
   */
  @java.lang.Deprecated
  int getEnvironmentsCount();

  /**
   *
   *
   * <pre>
   * Deprecated: please use environment(non-plural) instead.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environments = 6 [deprecated = true];</code>
   */
  @java.lang.Deprecated
  boolean containsEnvironments(java.lang.String key);

  /** Use {@link #getEnvironmentsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getEnvironments();

  /**
   *
   *
   * <pre>
   * Deprecated: please use environment(non-plural) instead.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environments = 6 [deprecated = true];</code>
   */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getEnvironmentsMap();

  /**
   *
   *
   * <pre>
   * Deprecated: please use environment(non-plural) instead.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environments = 6 [deprecated = true];</code>
   */
  @java.lang.Deprecated /* nullable */
  java.lang.String getEnvironmentsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);

  /**
   *
   *
   * <pre>
   * Deprecated: please use environment(non-plural) instead.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environments = 6 [deprecated = true];</code>
   */
  @java.lang.Deprecated
  java.lang.String getEnvironmentsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Volumes to mount before running Tasks using this TaskSpec.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
   */
  java.util.List<com.google.cloud.batch.v1.Volume> getVolumesList();

  /**
   *
   *
   * <pre>
   * Volumes to mount before running Tasks using this TaskSpec.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
   */
  com.google.cloud.batch.v1.Volume getVolumes(int index);

  /**
   *
   *
   * <pre>
   * Volumes to mount before running Tasks using this TaskSpec.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
   */
  int getVolumesCount();

  /**
   *
   *
   * <pre>
   * Volumes to mount before running Tasks using this TaskSpec.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
   */
  java.util.List<? extends com.google.cloud.batch.v1.VolumeOrBuilder> getVolumesOrBuilderList();

  /**
   *
   *
   * <pre>
   * Volumes to mount before running Tasks using this TaskSpec.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
   */
  com.google.cloud.batch.v1.VolumeOrBuilder getVolumesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Environment variables to set before running the Task.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.Environment environment = 10;</code>
   *
   * @return Whether the environment field is set.
   */
  boolean hasEnvironment();

  /**
   *
   *
   * <pre>
   * Environment variables to set before running the Task.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.Environment environment = 10;</code>
   *
   * @return The environment.
   */
  com.google.cloud.batch.v1.Environment getEnvironment();

  /**
   *
   *
   * <pre>
   * Environment variables to set before running the Task.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.Environment environment = 10;</code>
   */
  com.google.cloud.batch.v1.EnvironmentOrBuilder getEnvironmentOrBuilder();
}
