/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.tree.CommonTree;

public class ListToTreeCombiner {
    private LinkedList<CommonToken> hiddenTokens;

    public void associate(HiddenTokenAwareTree ast, LinkedList<CommonToken> hiddenTokens) {
        this.initialize(hiddenTokens);
        LinkedList<HiddenTokenAwareTree> children = this.getChildren(ast);
        this.associateAllchilds(children);
        if (children.isEmpty()) {
            this.addAllContainedTokens(ast);
        } else {
            HiddenTokenAwareTree lastChild = children.getLast();
            lastChild.addFollowing(hiddenTokens);
        }
    }

    private void initialize(LinkedList<CommonToken> hiddenTokens) {
        this.hiddenTokens = hiddenTokens;
    }

    private void associateAsChild(HiddenTokenAwareTree ast) {
        this.addAllPrecedingTokens(ast);
        LinkedList<HiddenTokenAwareTree> children = this.getChildren(ast);
        if (children.isEmpty()) {
            this.addAllContainedTokens(ast);
            return;
        }
        HiddenTokenAwareTree lastChild = this.associateAllchilds(children);
        this.addFollowingTokens(lastChild, ast.getTokenStopIndex());
    }

    private HiddenTokenAwareTree associateAllchilds(LinkedList<HiddenTokenAwareTree> children) {
        HiddenTokenAwareTree previousChild = null;
        for (HiddenTokenAwareTree child : children) {
            this.assignFirstCommentsSegment(previousChild, child);
            this.associateAsChild(child);
            previousChild = child;
        }
        return previousChild;
    }

    private void addFollowingTokens(HiddenTokenAwareTree target, int stop) {
        List<CommonToken> result = this.readPrefix(stop);
        target.addFollowing(result);
    }

    private void assignFirstCommentsSegment(HiddenTokenAwareTree firstChild, HiddenTokenAwareTree secondChild) {
        if (firstChild == null) {
            return;
        }
        LinkedList<CommonToken> tail = this.readTillNewLine(secondChild.getTokenStartIndex());
        if (tail.isEmpty()) {
            return;
        }
        if (tail.peekLast().getType() == 177) {
            firstChild.addFollowing(tail);
        } else {
            secondChild.addPreceding(tail);
        }
    }

    private void addAllContainedTokens(HiddenTokenAwareTree ast) {
        int stop = ast.getTokenStopIndex();
        List<CommonToken> result = this.readPrefix(stop);
        ast.addOrphans(result);
    }

    private LinkedList<HiddenTokenAwareTree> getChildren(HiddenTokenAwareTree ast) {
        List<HiddenTokenAwareTree> children = ast.getChildren();
        if (children == null) {
            return new LinkedList<HiddenTokenAwareTree>();
        }
        LinkedList<HiddenTokenAwareTree> copy = new LinkedList<HiddenTokenAwareTree>(children);
        Collections.sort(copy, new PositionComparator());
        return copy;
    }

    private void addAllPrecedingTokens(HiddenTokenAwareTree target) {
        int start = target.getTokenStartIndex();
        List<CommonToken> tokens = this.readPrefix(start);
        target.addPreceding(tokens);
    }

    private LinkedList<CommonToken> readTillNewLine(int end) {
        LinkedList<CommonToken> result = new LinkedList<CommonToken>();
        if (this.hiddenTokens.isEmpty()) {
            return result;
        }
        CommonToken first = this.hiddenTokens.peekFirst();
        while (first != null && first.getTokenIndex() < end && first.getType() == 164) {
            result.add(first);
            this.hiddenTokens.removeFirst();
            first = this.hiddenTokens.peekFirst();
        }
        if (first == null || first.getTokenIndex() >= end) {
            return result;
        }
        result.add(first);
        return result;
    }

    private List<CommonToken> readPrefix(int end) {
        ArrayList<CommonToken> result = new ArrayList<CommonToken>();
        if (this.hiddenTokens.isEmpty()) {
            return result;
        }
        CommonToken first = this.hiddenTokens.peekFirst();
        while (first != null && first.getTokenIndex() < end) {
            result.add(first);
            this.hiddenTokens.removeFirst();
            first = this.hiddenTokens.peekFirst();
        }
        return result;
    }

    class PositionComparator
    implements Comparator<CommonTree> {
        PositionComparator() {
        }

        @Override
        public int compare(CommonTree arg0, CommonTree arg1) {
            return arg0.getTokenStartIndex() - arg1.getTokenStartIndex();
        }
    }
}

