/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;

class CollectorTokenSource
implements TokenSource {
    private final TokenSource source;
    private final Set<Integer> collectTokenTypes = new HashSet<Integer>();
    private final LinkedList<CommonToken> collectedTokens = new LinkedList();

    public CollectorTokenSource(TokenSource source, Collection<Integer> collectTokenTypes) {
        this.source = source;
        this.collectTokenTypes.addAll(collectTokenTypes);
    }

    public CommonToken nextToken() {
        CommonToken nextToken = (CommonToken)this.source.nextToken();
        if (this.shouldCollect((Token)nextToken)) {
            this.collectedTokens.add(nextToken);
        }
        return nextToken;
    }

    protected boolean shouldCollect(Token nextToken) {
        return this.collectTokenTypes.contains(nextToken.getType());
    }

    public LinkedList<CommonToken> getCollectedTokens() {
        return this.collectedTokens;
    }

    public String getSourceName() {
        return this.source.getSourceName();
    }
}

