/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.ast.ReusableStructureName;
import com.github.sommeri.less4j.core.compiler.scopes.FullMixinDefinition;
import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.compiler.scopes.InScopeSnapshotRunner;
import com.github.sommeri.less4j.core.compiler.stages.AstNodesStack;
import com.github.sommeri.less4j.core.compiler.stages.ReferencesSolver;
import java.util.ArrayList;
import java.util.List;

public class MixinReferenceFinder {
    private final ReferencesSolver parentSolver;
    private final AstNodesStack semiCompiledNodes;
    private boolean foundNamespace = false;

    public MixinReferenceFinder(ReferencesSolver referencesSolver, AstNodesStack semiCompiledNodes) {
        this.parentSolver = referencesSolver;
        this.semiCompiledNodes = semiCompiledNodes;
    }

    public List<FullMixinDefinition> getNearestMixins(IScope scope, MixinReference reference) {
        this.foundNamespace = false;
        List<String> nameChain = reference.getNameChainAsStrings();
        IScope space = scope;
        List<FullMixinDefinition> result = this.findInMatchingNamespace(scope, nameChain, reference);
        while (result.isEmpty() && space.hasParent()) {
            space = space.getParent();
            result = this.findInMatchingNamespace(space, nameChain, reference);
        }
        return result;
    }

    public boolean foundNamespace() {
        return this.foundNamespace;
    }

    private List<FullMixinDefinition> getNearestLocalMixins(IScope scope, List<String> nameChain, ReusableStructureName name) {
        List<Object> mixins;
        if (scope.isBodyOwnerScope()) {
            scope = scope.firstChild();
        }
        if ((mixins = scope.getMixinsByName(nameChain, name)) != null) {
            mixins = this.removeLegalCycles(mixins, name);
        }
        return mixins == null ? new ArrayList() : mixins;
    }

    private List<FullMixinDefinition> removeLegalCycles(List<FullMixinDefinition> value, ReusableStructureName name) {
        ArrayList<FullMixinDefinition> result = new ArrayList<FullMixinDefinition>();
        for (FullMixinDefinition mixin : value) {
            if (this.participatesInCuttableCycle(mixin)) continue;
            result.add(mixin);
        }
        return result;
    }

    private boolean participatesInCuttableCycle(FullMixinDefinition mixin) {
        return mixin.getMixin().isAlsoRuleset() && this.semiCompiledNodes.contains(mixin.getMixin());
    }

    private List<FullMixinDefinition> findInMatchingNamespace(IScope scope, List<String> nameChain, MixinReference reference) {
        ArrayList<FullMixinDefinition> result = new ArrayList<FullMixinDefinition>();
        if (nameChain.isEmpty()) {
            this.foundNamespace = true;
        } else {
            for (int prefix = 1; prefix <= nameChain.size(); ++prefix) {
                String name = this.toName(nameChain.subList(0, prefix));
                ArrayList<String> theRest = prefix == nameChain.size() ? new ArrayList<String>() : nameChain.subList(prefix, nameChain.size());
                for (FullMixinDefinition fullMixin : scope.getMixinsByName(name)) {
                    List<FullMixinDefinition> foundInNamespaces = this.buildAndFind(fullMixin, theRest, reference);
                    result.addAll(foundInNamespaces);
                }
            }
        }
        result.addAll(this.getNearestLocalMixins(scope, nameChain, reference.getFinalName()));
        return result;
    }

    private String toName(List<String> list) {
        StringBuilder builder = new StringBuilder();
        for (String string : list) {
            builder.append(string);
        }
        return builder.toString();
    }

    private List<FullMixinDefinition> buildAndFind(FullMixinDefinition fullMixin, final List<String> nameChain, final MixinReference reference) {
        final ArrayList<FullMixinDefinition> result = new ArrayList<FullMixinDefinition>();
        ReusableStructure mixin = fullMixin.getMixin();
        final GeneralBody bodyClone = mixin.getBody().clone();
        final IScope scope = fullMixin.getScope();
        InScopeSnapshotRunner.runInLocalDataSnapshot(scope, new InScopeSnapshotRunner.ITask(){

            @Override
            public void run() {
                if (!MixinReferenceFinder.this.semiCompiledNodes.contains(bodyClone)) {
                    MixinReferenceFinder.this.parentSolver.unsafeDoSolveReferences((ASTCssNode)bodyClone, scope);
                }
                List found = MixinReferenceFinder.this.findInMatchingNamespace(scope, nameChain, reference);
                result.addAll(found);
            }
        });
        return result;
    }
}

