/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.ListExpressionOperator;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListExpression
extends Expression {
    private List<Expression> expressions;
    private ListExpressionOperator operator;

    public ListExpression(HiddenTokenAwareTree token, List<Expression> expressions, ListExpressionOperator operator) {
        super(token);
        this.expressions = expressions;
        this.operator = operator;
    }

    public ListExpressionOperator getOperator() {
        return this.operator;
    }

    public void setOperator(ListExpressionOperator operator) {
        this.operator = operator;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void addExpression(Expression expression) {
        this.expressions.add(expression);
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.LIST_EXPRESSION;
    }

    @Override
    public List<Expression> splitByComma() {
        if (this.operator.getOperator() != ListExpressionOperator.Operator.COMMA) {
            return super.splitByComma();
        }
        return new ArrayList<Expression>(this.getExpressions());
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        List<ASTCssNode> result = ArraysUtils.asNonNullList(this.operator);
        result.addAll(this.expressions);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        Iterator<Expression> iterator = this.expressions.iterator();
        if (iterator.hasNext()) {
            builder.append(iterator.next());
        }
        while (iterator.hasNext()) {
            builder.append((Object)this.operator.getOperator()).append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public ListExpression clone() {
        ListExpression clone = (ListExpression)super.clone();
        clone.expressions = ArraysUtils.deeplyClonedList(this.expressions);
        clone.operator = this.operator.clone();
        clone.configureParentToAllChilds();
        return clone;
    }
}

