/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ComposedExpression;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.CatchAllMultiParameterFunction;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.ArrayList;
import java.util.List;

class Extract
extends CatchAllMultiParameterFunction {
    Extract() {
    }

    @Override
    protected Expression evaluate(List<Expression> splitParameters, ProblemsHandler problemsHandler, HiddenTokenAwareTree token) {
        List<Expression> values = this.collect((ComposedExpression)splitParameters.get(0));
        NumberExpression index = (NumberExpression)splitParameters.get(1);
        return values.get(index.getValueAsDouble().intValue() - 1);
    }

    private List<Expression> collect(ComposedExpression values) {
        ArrayList<Expression> result = new ArrayList<Expression>();
        Expression left = values.getLeft();
        Expression right = values.getRight();
        if (left.getType() == ASTCssNodeType.COMPOSED_EXPRESSION) {
            result.addAll(this.collect((ComposedExpression)left));
        } else {
            result.add(left);
        }
        if (right.getType() == ASTCssNodeType.COMPOSED_EXPRESSION) {
            result.addAll(this.collect((ComposedExpression)right));
        } else {
            result.add(right);
        }
        return result;
    }

    @Override
    protected int getMinParameters() {
        return 2;
    }

    @Override
    protected int getMaxParameters() {
        return 2;
    }

    @Override
    protected boolean validateParameter(Expression parameter, int position, ProblemsHandler problemsHandler) {
        switch (position) {
            case 0: {
                return this.validateParameterTypeReportError(parameter, problemsHandler, ASTCssNodeType.COMPOSED_EXPRESSION);
            }
            case 1: {
                return this.validateParameterTypeReportError(parameter, problemsHandler, ASTCssNodeType.NUMBER);
            }
        }
        return false;
    }

    @Override
    protected String getName() {
        return "extract";
    }
}

