/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.utils;

import com.github.sommeri.less4j.core.ExtendedStringBuilder;
import com.github.sommeri.less4j.core.NotACssException;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.CharsetDeclaration;
import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.Comment;
import com.github.sommeri.less4j.core.ast.ComposedExpression;
import com.github.sommeri.less4j.core.ast.CssClass;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.Declaration;
import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.EscapedSelector;
import com.github.sommeri.less4j.core.ast.EscapedValue;
import com.github.sommeri.less4j.core.ast.ExpressionOperator;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.FontFace;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.IdSelector;
import com.github.sommeri.less4j.core.ast.IdentifierExpression;
import com.github.sommeri.less4j.core.ast.Keyframes;
import com.github.sommeri.less4j.core.ast.KeyframesBody;
import com.github.sommeri.less4j.core.ast.KeyframesName;
import com.github.sommeri.less4j.core.ast.Media;
import com.github.sommeri.less4j.core.ast.MediaExpression;
import com.github.sommeri.less4j.core.ast.MediaExpressionFeature;
import com.github.sommeri.less4j.core.ast.MediaQuery;
import com.github.sommeri.less4j.core.ast.Medium;
import com.github.sommeri.less4j.core.ast.MediumModifier;
import com.github.sommeri.less4j.core.ast.MediumType;
import com.github.sommeri.less4j.core.ast.Name;
import com.github.sommeri.less4j.core.ast.NamedColorExpression;
import com.github.sommeri.less4j.core.ast.NamedExpression;
import com.github.sommeri.less4j.core.ast.Nth;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.ast.Page;
import com.github.sommeri.less4j.core.ast.PageMarginBox;
import com.github.sommeri.less4j.core.ast.PseudoClass;
import com.github.sommeri.less4j.core.ast.PseudoElement;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.RuleSetsBody;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.SelectorAttribute;
import com.github.sommeri.less4j.core.ast.SelectorCombinator;
import com.github.sommeri.less4j.core.ast.SelectorOperator;
import com.github.sommeri.less4j.core.ast.SimpleSelector;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.ast.Viewport;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class CssPrinter {
    protected ExtendedStringBuilder builder = new ExtendedStringBuilder();
    private static final DecimalFormat FORMATTER = new DecimalFormat("#.##################");

    public boolean append(ASTCssNode node) {
        if (node == null) {
            return false;
        }
        this.appendComments(node.getOpeningComments(), true);
        boolean result = this.switchOnType(node);
        this.appendComments(node.getTrailingComments(), false);
        return result;
    }

    public boolean switchOnType(ASTCssNode node) {
        switch (node.getType()) {
            case RULE_SET: {
                return this.appendRuleset((RuleSet)node);
            }
            case DECLARATIONS_BODY: {
                return this.appendBodyOptimizeDuplicates((RuleSetsBody)node);
            }
            case CSS_CLASS: {
                return this.appendCssClass((CssClass)node);
            }
            case PSEUDO_CLASS: {
                return this.appendPseudoClass((PseudoClass)node);
            }
            case PSEUDO_ELEMENT: {
                return this.appendPseudoElement((PseudoElement)node);
            }
            case NTH: {
                return this.appendNth((Nth)node);
            }
            case SELECTOR: {
                return this.appendSelector((Selector)node);
            }
            case SIMPLE_SELECTOR: {
                return this.appendSimpleSelector((SimpleSelector)node);
            }
            case SELECTOR_OPERATOR: {
                return this.appendSelectorOperator((SelectorOperator)node);
            }
            case SELECTOR_COMBINATOR: {
                return this.appendSelectorCombinator((SelectorCombinator)node);
            }
            case SELECTOR_ATTRIBUTE: {
                return this.appendSelectorAttribute((SelectorAttribute)node);
            }
            case ID_SELECTOR: {
                return this.appendIdSelector((IdSelector)node);
            }
            case CHARSET_DECLARATION: {
                return this.appendCharsetDeclaration((CharsetDeclaration)node);
            }
            case FONT_FACE: {
                return this.appendFontFace((FontFace)node);
            }
            case NAMED_EXPRESSION: {
                return this.appendNamedExpression((NamedExpression)node);
            }
            case COMPOSED_EXPRESSION: {
                return this.appendComposedExpression((ComposedExpression)node);
            }
            case EXPRESSION_OPERATOR: {
                return this.appendExpressionOperator((ExpressionOperator)node);
            }
            case STRING_EXPRESSION: {
                return this.appendCssString((CssString)node);
            }
            case NUMBER: {
                return this.appendNumberExpression((NumberExpression)node);
            }
            case IDENTIFIER_EXPRESSION: {
                return this.appendIdentifierExpression((IdentifierExpression)node);
            }
            case COLOR_EXPRESSION: {
                return this.appendColorExpression((ColorExpression)node);
            }
            case FUNCTION: {
                return this.appendFunctionExpression((FunctionExpression)node);
            }
            case DECLARATION: {
                return this.appendDeclaration((Declaration)node);
            }
            case MEDIA: {
                return this.appendMedia((Media)node);
            }
            case MEDIA_QUERY: {
                return this.appendMediaQuery((MediaQuery)node);
            }
            case MEDIUM: {
                return this.appendMedium((Medium)node);
            }
            case MEDIUM_MODIFIER: {
                return this.appendMediumModifier((MediumModifier)node);
            }
            case MEDIUM_TYPE: {
                return this.appendMediumType((MediumType)node);
            }
            case MEDIA_EXPRESSION: {
                return this.appendMediaExpression((MediaExpression)node);
            }
            case MEDIUM_EX_FEATURE: {
                return this.appendMediaExpressionFeature((MediaExpressionFeature)node);
            }
            case STYLE_SHEET: {
                return this.appendStyleSheet((StyleSheet)node);
            }
            case FAULTY_EXPRESSION: {
                return this.appendFaultyExpression((FaultyExpression)node);
            }
            case ESCAPED_SELECTOR: {
                return this.appendEscapedSelector((EscapedSelector)node);
            }
            case ESCAPED_VALUE: {
                return this.appendEscapedValue((EscapedValue)node);
            }
            case KEYFRAMES: {
                return this.appendKeyframes((Keyframes)node);
            }
            case KEYFRAMES_NAME: {
                return this.appendKeyframesName((KeyframesName)node);
            }
            case KEYFRAMES_BODY: {
                return this.appendBodyOptimizeDuplicates((KeyframesBody)node);
            }
            case VIEWPORT: {
                return this.appendViewport((Viewport)node);
            }
            case GENERAL_BODY: {
                return this.appendBodyOptimizeDuplicates((GeneralBody)node);
            }
            case PAGE: {
                return this.appendPage((Page)node);
            }
            case PAGE_MARGIN_BOX: {
                return this.appendPageMarginBox((PageMarginBox)node);
            }
            case NAME: {
                return this.appendName((Name)node);
            }
            case PARENTHESES_EXPRESSION: 
            case SIGNED_EXPRESSION: 
            case VARIABLE: 
            case INDIRECT_VARIABLE: 
            case VARIABLE_DECLARATION: {
                throw new NotACssException(node);
            }
        }
        throw new IllegalStateException("Unknown: " + (Object)((Object)node.getType()) + " " + node.getSourceLine() + ":" + node.getCharPositionInSourceLine());
    }

    private boolean appendName(Name node) {
        this.builder.append(node.getName());
        return true;
    }

    private boolean appendPage(Page node) {
        this.builder.append("@page").ensureSeparator();
        if (node.hasName()) {
            this.append(node.getName());
            if (!node.hasDockedPseudopage()) {
                this.builder.ensureSeparator();
            }
        }
        if (node.hasPseudopage()) {
            this.append(node.getPseudopage());
            this.builder.ensureSeparator();
        }
        this.appendBodySortDeclarations(node.getBody());
        return true;
    }

    private boolean appendPageMarginBox(PageMarginBox node) {
        this.append(node.getName());
        this.appendBodySortDeclarations(node.getBody());
        return true;
    }

    private boolean appendKeyframesName(KeyframesName node) {
        this.builder.append(node.getName());
        return true;
    }

    private boolean appendKeyframes(Keyframes node) {
        this.builder.append(node.getDialect()).ensureSeparator();
        Iterator<KeyframesName> names = node.getNames().iterator();
        if (names.hasNext()) {
            this.append(names.next());
        }
        while (names.hasNext()) {
            this.builder.append(",").ensureSeparator();
            this.append(names.next());
        }
        this.append(node.getBody());
        return true;
    }

    private boolean appendViewport(Viewport node) {
        this.builder.append("@viewport");
        this.append(node.getBody());
        return true;
    }

    private boolean appendFaultyExpression(FaultyExpression node) {
        this.builder.append("!#error#!");
        return true;
    }

    private boolean appendNth(Nth node) {
        switch (node.getForm()) {
            case EVEN: {
                this.builder.append("even");
                return true;
            }
            case ODD: {
                this.builder.append("odd");
                return true;
            }
            case STANDARD: {
                if (node.getRepeater() != null) {
                    this.append(node.getRepeater());
                }
                if (node.getMod() == null) break;
                this.append(node.getMod());
            }
        }
        return true;
    }

    protected void appendComments(List<Comment> comments, boolean ensureSeparator) {
        if (comments == null || comments.isEmpty()) {
            return;
        }
        this.builder.ensureSeparator();
        for (Comment comment : comments) {
            this.builder.append(comment.getComment());
            if (!comment.hasNewLine()) continue;
            this.builder.newLine();
        }
        if (ensureSeparator) {
            this.builder.ensureSeparator();
        }
    }

    public boolean appendFontFace(FontFace node) {
        this.builder.append("@font-face {").newLine();
        this.builder.increaseIndentationLevel();
        this.appendAllChilds(node);
        this.builder.decreaseIndentationLevel();
        this.builder.append("}");
        return true;
    }

    public boolean appendCharsetDeclaration(CharsetDeclaration node) {
        this.builder.append("@charset").ensureSeparator();
        this.builder.append(node.getCharset());
        this.builder.append(";");
        return true;
    }

    public boolean appendIdSelector(IdSelector node) {
        this.builder.append("#");
        this.builder.append(node.getName());
        return true;
    }

    public boolean appendSelectorAttribute(SelectorAttribute node) {
        this.builder.append("[");
        this.builder.append(node.getName());
        this.append(node.getOperator());
        this.builder.appendIgnoreNull(node.getValue());
        this.builder.append("]");
        return true;
    }

    private boolean appendSelectorOperator(SelectorOperator operator) {
        SelectorOperator.Operator realOperator = operator.getOperator();
        switch (realOperator) {
            case NONE: {
                break;
            }
            default: {
                this.builder.append(realOperator.getSymbol());
            }
        }
        return true;
    }

    public boolean appendPseudoClass(PseudoClass node) {
        this.builder.append(":");
        this.builder.append(node.getName());
        if (node.hasParameters()) {
            this.builder.append("(");
            this.append(node.getParameter());
            this.builder.append(")");
        }
        return true;
    }

    public boolean appendPseudoElement(PseudoElement node) {
        this.builder.append(":");
        if (!node.isLevel12Form()) {
            this.builder.append(":");
        }
        this.builder.append(node.getName());
        return true;
    }

    public boolean appendStyleSheet(StyleSheet styleSheet) {
        this.appendComments(styleSheet.getOrphanComments(), false);
        this.appendAllChilds(styleSheet);
        return true;
    }

    public boolean appendRuleset(RuleSet ruleSet) {
        if (ruleSet.hasEmptyBody()) {
            return false;
        }
        this.appendSelectors(ruleSet.getSelectors());
        this.append(ruleSet.getBody());
        return true;
    }

    public boolean appendBodyOptimizeDuplicates(Body<? extends ASTCssNode> body) {
        if (body.isEmpty()) {
            return false;
        }
        this.builder.ensureSeparator().append("{").newLine();
        this.builder.increaseIndentationLevel();
        LinkedHashSet<String> declarationsBuilders = this.collectUniqueBodyMembersStrings(body);
        for (String miniBuilder : declarationsBuilders) {
            this.builder.appendAsIs(miniBuilder);
        }
        this.appendComments(body.getOrphanComments(), false);
        this.builder.decreaseIndentationLevel();
        this.builder.append("}");
        return true;
    }

    private LinkedHashSet<String> collectUniqueBodyMembersStrings(Body<? extends ASTCssNode> body) {
        ExtendedStringBuilder storedBuilder = this.builder;
        LinkedHashSet<String> declarationsStrings = new LinkedHashSet<String>();
        for (ASTCssNode aSTCssNode : body.getChilds()) {
            this.builder = new ExtendedStringBuilder(this.builder);
            this.append(aSTCssNode);
            this.builder.ensureNewLine();
            String declarationSnipped = this.builder.toString();
            if (declarationsStrings.contains(declarationSnipped)) {
                declarationsStrings.remove(declarationSnipped);
            }
            declarationsStrings.add(declarationSnipped);
        }
        storedBuilder.configureFrom(this.builder);
        this.builder = storedBuilder;
        return declarationsStrings;
    }

    public boolean appendDeclaration(Declaration declaration) {
        this.builder.appendIgnoreNull(declaration.getName());
        this.builder.append(":").ensureSeparator();
        if (declaration.getExpression() != null) {
            this.append(declaration.getExpression());
        }
        if (declaration.isImportant()) {
            this.builder.ensureSeparator().append("!important");
        }
        this.builder.appendIgnoreNull(";");
        return true;
    }

    public boolean appendMedia(Media node) {
        this.builder.append("@media");
        this.appendMediums(node.getMediums());
        this.appendBodySortDeclarations(node);
        return true;
    }

    private void appendBodySortDeclarations(Body<ASTCssNode> node) {
        this.builder.ensureSeparator().append("{").newLine();
        this.builder.increaseIndentationLevel();
        Iterator<ASTCssNode> declarations = node.getDeclarations().iterator();
        List<ASTCssNode> notDeclarations = node.getNotDeclarations();
        while (declarations.hasNext()) {
            ASTCssNode declaration = declarations.next();
            this.append(declaration);
            if (!declarations.hasNext() && !notDeclarations.isEmpty()) continue;
            this.builder.ensureNewLine();
        }
        for (ASTCssNode body : notDeclarations) {
            boolean changedAnything = this.append(body);
            if (!changedAnything) continue;
            this.builder.ensureNewLine();
        }
        this.builder.decreaseIndentationLevel();
        this.builder.append("}");
    }

    private void appendMediums(List<MediaQuery> mediums) {
        if (mediums == null || mediums.isEmpty()) {
            return;
        }
        boolean needComma = false;
        for (MediaQuery mediaQuery : mediums) {
            if (needComma) {
                this.builder.append(",").ensureSeparator();
            }
            this.append(mediaQuery);
            needComma = true;
        }
    }

    public boolean appendMediaQuery(MediaQuery mediaQuery) {
        this.builder.ensureSeparator();
        this.append(mediaQuery.getMedium());
        boolean needSeparator = mediaQuery.getMedium() != null;
        for (MediaExpression mediaExpression : mediaQuery.getExpressions()) {
            if (needSeparator) {
                this.builder.ensureSeparator().append("and");
            }
            this.append(mediaExpression);
            needSeparator = true;
        }
        return true;
    }

    public boolean appendMedium(Medium medium) {
        this.append(medium.getModifier());
        this.append(medium.getMediumType());
        return true;
    }

    public boolean appendMediumModifier(MediumModifier modifier) {
        MediumModifier.Modifier kind = modifier.getModifier();
        switch (kind) {
            case ONLY: {
                this.builder.ensureSeparator().append("only");
                break;
            }
            case NOT: {
                this.builder.ensureSeparator().append("not");
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown modifier type.");
            }
        }
        return true;
    }

    public boolean appendMediumType(MediumType medium) {
        this.builder.ensureSeparator().append(medium.getName());
        return true;
    }

    public boolean appendMediaExpression(MediaExpression expression) {
        this.builder.ensureSeparator().append("(");
        this.append(expression.getFeature());
        if (expression.getExpression() != null) {
            this.builder.append(":").ensureSeparator();
            this.append(expression.getExpression());
        }
        this.builder.append(")");
        return true;
    }

    public boolean appendMediaExpressionFeature(MediaExpressionFeature feature) {
        this.builder.append(feature.getFeature());
        return true;
    }

    public boolean appendNamedExpression(NamedExpression expression) {
        this.builder.append(expression.getName());
        this.builder.append("=");
        this.append(expression.getExpression());
        return true;
    }

    public boolean appendComposedExpression(ComposedExpression expression) {
        this.append(expression.getLeft());
        this.append(expression.getOperator());
        this.append(expression.getRight());
        return true;
    }

    public boolean appendExpressionOperator(ExpressionOperator operator) {
        ExpressionOperator.Operator realOperator = operator.getOperator();
        switch (realOperator) {
            case COMMA: {
                this.builder.append(realOperator.getSymbol()).ensureSeparator();
                break;
            }
            case EMPTY_OPERATOR: {
                this.builder.ensureSeparator();
                break;
            }
            case MINUS: {
                this.builder.ensureSeparator().append("-");
                break;
            }
            default: {
                this.builder.append(realOperator.getSymbol());
            }
        }
        return true;
    }

    public boolean appendCssString(CssString expression) {
        String quoteType = expression.getQuoteType();
        this.builder.append(quoteType).append(expression.getValue()).append(quoteType);
        return true;
    }

    public boolean appendEscapedSelector(EscapedSelector escaped) {
        this.builder.append(escaped.getValue());
        return true;
    }

    public boolean appendEscapedValue(EscapedValue escaped) {
        this.builder.append(escaped.getValue());
        return true;
    }

    public boolean appendIdentifierExpression(IdentifierExpression expression) {
        this.builder.append(expression.getValue());
        return true;
    }

    protected boolean appendColorExpression(ColorExpression expression) {
        if (expression instanceof NamedColorExpression) {
            NamedColorExpression named = (NamedColorExpression)expression;
            this.builder.append(named.getColorName());
        } else {
            this.builder.append(expression.getValue());
        }
        return true;
    }

    private boolean appendFunctionExpression(FunctionExpression node) {
        this.builder.append(node.getName());
        this.builder.append("(");
        this.append(node.getParameter());
        this.builder.append(")");
        return true;
    }

    private boolean appendNumberExpression(NumberExpression node) {
        if (node.hasOriginalString()) {
            this.builder.append(node.getOriginalString());
        } else {
            if (node.hasExpliciteSign()) {
                if (0.0 < node.getValueAsDouble()) {
                    this.builder.append("+");
                } else {
                    this.builder.append("-");
                }
            }
            this.builder.append(this.format(node.getValueAsDouble()) + node.getSuffix());
        }
        return true;
    }

    public void appendSelectors(List<Selector> selectors) {
        Iterator<Selector> iterator = selectors.iterator();
        while (iterator.hasNext()) {
            Selector selector = iterator.next();
            this.append(selector);
            if (!iterator.hasNext()) continue;
            this.builder.append(",").newLine();
        }
    }

    public boolean appendSelector(Selector selector) {
        if (selector.hasLeadingCombinator()) {
            this.append(selector.getLeadingCombinator());
        }
        if (!selector.isCombined()) {
            this.append(selector.getHead());
            return true;
        }
        this.append(selector.getHead());
        this.append(selector.getRight());
        return true;
    }

    private boolean appendSimpleSelector(SimpleSelector selector) {
        this.appendSimpleSelectorHead(selector);
        this.appendSimpleSelectorTail(selector);
        return true;
    }

    private void appendSimpleSelectorTail(SimpleSelector selector) {
        List<ElementSubsequent> allChilds = selector.getSubsequent();
        for (ElementSubsequent astCssNode : allChilds) {
            this.append(astCssNode);
        }
    }

    private boolean appendCssClass(CssClass cssClass) {
        this.builder.append(".").append(cssClass.getName());
        return true;
    }

    private void appendSimpleSelectorHead(SimpleSelector selector) {
        this.builder.ensureSeparator();
        if (selector.isStar()) {
            if (!selector.isEmptyForm()) {
                this.builder.append("*");
            }
        } else {
            this.builder.appendIgnoreNull(selector.getElementName().getName());
        }
    }

    public boolean appendSelectorCombinator(SelectorCombinator combinator) {
        SelectorCombinator.Combinator realCombinator = combinator.getCombinator();
        switch (realCombinator) {
            case DESCENDANT: {
                this.builder.ensureSeparator();
                break;
            }
            default: {
                this.builder.ensureSeparator().append(realCombinator.getSymbol());
            }
        }
        return true;
    }

    private void appendAllChilds(ASTCssNode node) {
        List<? extends ASTCssNode> allChilds = node.getChilds();
        this.appendAll(allChilds);
    }

    private void appendAll(List<? extends ASTCssNode> all) {
        for (ASTCssNode aSTCssNode : all) {
            if (!this.append(aSTCssNode)) continue;
            this.builder.ensureNewLine();
        }
    }

    private String format(Double valueAsDouble) {
        if (valueAsDouble.isNaN()) {
            return "NaN";
        }
        return FORMATTER.format(valueAsDouble);
    }

    public String toString() {
        return this.builder.toString();
    }
}

