/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.scopes;

import com.github.sommeri.less4j.core.ast.AbstractVariableDeclaration;
import com.github.sommeri.less4j.core.ast.Expression;
import java.util.HashMap;
import java.util.Map;

public class VariablesScope {
    private Map<String, Expression> variables = new HashMap<String, Expression>();

    public VariablesScope(VariablesScope scope) {
        this.variables = new HashMap<String, Expression>(scope.variables);
    }

    public VariablesScope() {
    }

    public VariablesScope(VariablesScope scope1, VariablesScope scope2) {
        this(scope1);
        this.variables.putAll(scope2.variables);
    }

    public Expression getValue(String name) {
        return this.variables.get(name);
    }

    public void addDeclaration(AbstractVariableDeclaration node) {
        this.variables.put(node.getVariable().getName(), node.getValue());
    }

    public void addDeclaration(AbstractVariableDeclaration node, Expression replacementValue) {
        this.variables.put(node.getVariable().getName(), replacementValue);
    }

    public void addDeclaration(String name, Expression replacementValue) {
        this.variables.put(name, replacementValue);
    }

    public void addDeclarationIfNotPresent(String name, Expression replacementValue) {
        if (!this.variables.containsKey(name)) {
            this.variables.put(name, replacementValue);
        }
    }

    public void removeDeclaration(String name) {
        this.variables.remove(name);
    }

    public int size() {
        return this.variables.size();
    }
}

