/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.IdentifierExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.ast.SignedExpression;

public abstract class ExpressionComparator {
    public boolean equal(Expression pattern, Expression expression) {
        switch (pattern.getType()) {
            case SIGNED_EXPRESSION: {
                return this.equalSigned((SignedExpression)pattern, expression);
            }
            case IDENTIFIER_EXPRESSION: {
                return this.equalIdentifier((IdentifierExpression)pattern, expression);
            }
            case NUMBER: {
                return this.equalNumber((NumberExpression)pattern, expression);
            }
            case STRING_EXPRESSION: {
                return this.equalString((CssString)pattern, expression);
            }
            case COLOR_EXPRESSION: {
                return this.equalColor((ColorExpression)pattern, expression);
            }
        }
        return false;
    }

    private boolean equalColor(ColorExpression pattern, Expression expression) {
        if (expression instanceof ColorExpression) {
            return this.equals(pattern.getValue(), ((ColorExpression)expression).getValue());
        }
        return false;
    }

    private boolean equalString(CssString pattern, Expression expression) {
        if (expression instanceof CssString) {
            CssString string = (CssString)expression;
            return this.equals(pattern.getValue(), string.getValue()) && this.equals(pattern.getQuoteType(), string.getQuoteType());
        }
        return false;
    }

    private boolean equalNumber(NumberExpression pattern, Expression expression) {
        if (expression instanceof NumberExpression) {
            NumberExpression numberExpression = (NumberExpression)expression;
            return this.numberEqual(pattern, numberExpression);
        }
        return false;
    }

    protected abstract boolean numberEqual(NumberExpression var1, NumberExpression var2);

    private boolean equalIdentifier(IdentifierExpression pattern, Expression expression) {
        if (expression instanceof IdentifierExpression) {
            return this.equals(pattern.getValue(), ((IdentifierExpression)expression).getValue());
        }
        return false;
    }

    private boolean equalSigned(SignedExpression pattern, Expression expression) {
        if (expression instanceof SignedExpression) {
            return this.equalNegated(pattern, (SignedExpression)expression);
        }
        if (expression instanceof NumberExpression && pattern.getExpression() instanceof NumberExpression) {
            NumberExpression patternClone = (NumberExpression)pattern.getExpression().clone();
            if (pattern.getSign() == SignedExpression.Sign.MINUS) {
                patternClone.setValueAsDouble(patternClone.getValueAsDouble() * -1.0);
            }
            NumberExpression number = (NumberExpression)expression;
            return this.equalNumber(patternClone, number);
        }
        return false;
    }

    private boolean equalNegated(SignedExpression pattern, SignedExpression expression) {
        return this.equal(pattern.getExpression(), expression.getExpression());
    }

    protected boolean equals(Object value, Object value2) {
        if (value == null) {
            return value2 == null;
        }
        return value.equals(value2);
    }

    protected boolean equals(Double value, Double value2) {
        if (value == null) {
            return value2 == null;
        }
        return (value = this.normalize0(value)).compareTo(value2 = this.normalize0(value2)) == 0;
    }

    private Double normalize0(Double value) {
        if (value.compareTo(-0.0) == 0) {
            value = 0.0;
        }
        return value;
    }
}

