/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.EscapedValue;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.compiler.expressions.Function;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.utils.PrintUtils;

class Escape
implements Function {
    Escape() {
    }

    @Override
    public Expression evaluate(Expression parameters, ProblemsHandler problemsHandler) {
        if (parameters.getType() == ASTCssNodeType.STRING_EXPRESSION) {
            return this.evaluate((CssString)parameters);
        }
        if (parameters.getType() == ASTCssNodeType.ESCAPED_VALUE) {
            return this.evaluate((EscapedValue)parameters);
        }
        problemsHandler.warnEscapeFunctionArgument(parameters);
        if (parameters.getType() == ASTCssNodeType.COLOR_EXPRESSION) {
            return this.evaluate((ColorExpression)parameters);
        }
        return parameters;
    }

    private Expression evaluate(ColorExpression parameters) {
        return new CssString(parameters.getUnderlyingStructure(), "undefined", "");
    }

    private CssString evaluate(EscapedValue parameters) {
        String newValue = PrintUtils.toUtf8ExceptURL(parameters.getValue());
        return new CssString(parameters.getUnderlyingStructure(), newValue, "");
    }

    private CssString evaluate(CssString parameters) {
        String newValue = PrintUtils.toUtf8ExceptURL(parameters.getValue());
        return new CssString(parameters.getUnderlyingStructure(), newValue, "");
    }
}

