/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.EscapedValue;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.Function;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.utils.InStringCssPrinter;

class E
implements Function {
    E() {
    }

    @Override
    public Expression evaluate(Expression parameters, ProblemsHandler problemsHandler) {
        if (parameters.getType() == ASTCssNodeType.STRING_EXPRESSION) {
            return this.evaluate((CssString)parameters);
        }
        if (parameters.getType() == ASTCssNodeType.ESCAPED_VALUE) {
            return this.evaluate((EscapedValue)parameters);
        }
        if (parameters.getType() == ASTCssNodeType.NUMBER) {
            return this.evaluate((NumberExpression)parameters);
        }
        problemsHandler.warnEFunctionArgument(parameters);
        return new FaultyExpression(parameters);
    }

    private Expression evaluate(NumberExpression parameters) {
        InStringCssPrinter printer = new InStringCssPrinter();
        printer.append(parameters);
        return new CssString(parameters.getUnderlyingStructure(), printer.toString(), "");
    }

    private Expression evaluate(EscapedValue parameters) {
        return parameters;
    }

    private CssString evaluate(CssString parameters) {
        return new CssString(parameters.getUnderlyingStructure(), parameters.getValue(), "");
    }
}

