/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.ComposedExpression;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.ExpressionOperator;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;

class ColorsCalculator {
    private final ProblemsHandler problemsHandler;
    private static final int MIN = 0;
    private static final int MAX = 255;

    public ColorsCalculator(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    public Expression evalute(ComposedExpression originalExpression, Expression first, Expression second) {
        double red1 = this.calcRed(first);
        double green1 = this.calcGreen(first);
        double blue1 = this.calcBlue(first);
        double red2 = this.calcRed(second);
        double green2 = this.calcGreen(second);
        double blue2 = this.calcBlue(second);
        ExpressionOperator operator = originalExpression.getOperator();
        switch (operator.getOperator()) {
            case SOLIDUS: {
                return this.divide(first, red1, green1, blue1, red2, green2, blue2, originalExpression.getUnderlyingStructure());
            }
            case STAR: {
                return this.multiply(red1, green1, blue1, red2, green2, blue2, originalExpression.getUnderlyingStructure());
            }
            case MINUS: {
                return this.subtract(first, red1, green1, blue1, red2, green2, blue2, originalExpression.getUnderlyingStructure());
            }
            case PLUS: {
                return this.add(red1, green1, blue1, red2, green2, blue2, originalExpression.getUnderlyingStructure());
            }
            case COMMA: 
            case EMPTY_OPERATOR: {
                throw new BugHappened("Not a color operator.", (ASTCssNode)operator);
            }
        }
        throw new BugHappened("Unknown operator.", (ASTCssNode)operator);
    }

    private Expression subtract(Expression first, double red1, double green1, double blue1, double red2, double green2, double blue2, HiddenTokenAwareTree parentToken) {
        if (first.getType() == ASTCssNodeType.NUMBER) {
            this.problemsHandler.subtractOrDiveColorFromNumber(first);
            return new FaultyExpression(first);
        }
        return this.createResultColor(parentToken, this.round(red1 - red2), this.round(green1 - green2), this.round(blue1 - blue2));
    }

    private ColorExpression multiply(double red1, double green1, double blue1, double red2, double green2, double blue2, HiddenTokenAwareTree parentToken) {
        return this.createResultColor(parentToken, this.round(red1 * red2), this.round(green1 * green2), this.round(blue1 * blue2));
    }

    private Expression divide(Expression first, double red1, double green1, double blue1, double red2, double green2, double blue2, HiddenTokenAwareTree parentToken) {
        if (first.getType() == ASTCssNodeType.NUMBER) {
            this.problemsHandler.subtractOrDiveColorFromNumber(first);
            return new FaultyExpression(first);
        }
        return this.createResultColor(parentToken, this.round(red1 / red2), this.round(green1 / green2), this.round(blue1 / blue2));
    }

    private ColorExpression add(double red1, double green1, double blue1, double red2, double green2, double blue2, HiddenTokenAwareTree parentToken) {
        return this.createResultColor(parentToken, this.round(red1 + red2), this.round(green1 + green2), this.round(blue1 + blue2));
    }

    private int round(double number) {
        if (number > 255.0) {
            return 255;
        }
        return number < 0.0 ? 0 : (int)Math.round(number);
    }

    private ColorExpression createResultColor(HiddenTokenAwareTree parentToken, double red, double green, double blue) {
        return new ColorExpression(parentToken, this.round(red), this.round(green), this.round(blue));
    }

    public boolean accepts(ExpressionOperator operator, Expression first, Expression second) {
        if (!this.acceptedOperand(first, second)) {
            return false;
        }
        return this.acceptedOperator(operator);
    }

    private boolean acceptedOperator(ExpressionOperator operator) {
        return operator.getOperator() != ExpressionOperator.Operator.COMMA && operator.getOperator() != ExpressionOperator.Operator.EMPTY_OPERATOR;
    }

    private boolean acceptedOperand(Expression first, Expression second) {
        if (first.getType() != ASTCssNodeType.COLOR_EXPRESSION && first.getType() != ASTCssNodeType.NUMBER) {
            return false;
        }
        if (second.getType() != ASTCssNodeType.COLOR_EXPRESSION && second.getType() != ASTCssNodeType.NUMBER) {
            return false;
        }
        return first.getType() == ASTCssNodeType.COLOR_EXPRESSION || second.getType() == ASTCssNodeType.COLOR_EXPRESSION;
    }

    private double calcRed(Expression value) {
        if (value instanceof ColorExpression) {
            return ((ColorExpression)value).getRed();
        }
        return ((NumberExpression)value).getValueAsDouble();
    }

    private double calcGreen(Expression value) {
        if (value instanceof ColorExpression) {
            return ((ColorExpression)value).getGreen();
        }
        return ((NumberExpression)value).getValueAsDouble();
    }

    private double calcBlue(Expression value) {
        if (value instanceof ColorExpression) {
            return ((ColorExpression)value).getBlue();
        }
        return ((NumberExpression)value).getValueAsDouble();
    }
}

