/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.ast.ReusableStructureName;
import com.github.sommeri.less4j.core.ast.RuleSetsBody;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.SelectorPart;
import com.github.sommeri.less4j.core.ast.SimpleSelector;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public class RuleSet
extends ASTCssNode {
    private List<Selector> selectors = new ArrayList<Selector>();
    private RuleSetsBody body;

    public RuleSet(HiddenTokenAwareTree token) {
        super(token);
    }

    public RuleSet(HiddenTokenAwareTree token, RuleSetsBody body, List<Selector> selectors) {
        super(token);
        this.body = body;
        this.addSelectors(selectors);
        this.configureParentToAllChilds();
    }

    public List<Selector> getSelectors() {
        return this.selectors;
    }

    public RuleSetsBody getBody() {
        return this.body;
    }

    public boolean hasEmptyBody() {
        return this.body == null ? true : this.body.isEmpty();
    }

    public void setBody(RuleSetsBody body) {
        this.body = body;
    }

    public boolean usableAsReusableStructure() {
        for (Selector selector : this.selectors) {
            if (!this.isReusableSelector(selector)) continue;
            return true;
        }
        return false;
    }

    private boolean isReusableSelector(Selector selector) {
        if (selector.isCombined()) {
            return false;
        }
        SelectorPart head = selector.getHead();
        return head.isClassesAndIdsOnlySelector();
    }

    public ReusableStructure convertToReusableStructure() {
        if (!this.usableAsReusableStructure()) {
            throw new BugHappened("Caller is supposed to check for this.", (ASTCssNode)this);
        }
        ArrayList<ReusableStructureName> reusableNames = new ArrayList<ReusableStructureName>();
        for (Selector selector : this.selectors) {
            if (!this.isReusableSelector(selector)) continue;
            SimpleSelector head = (SimpleSelector)selector.getHead();
            reusableNames.add(new ReusableStructureName(head.getUnderlyingStructure(), head.getSubsequent()));
        }
        ReusableStructure reusable = new ReusableStructure(this.getUnderlyingStructure(), reusableNames);
        reusable.setBody(this.getBody().clone());
        reusable.configureParentToAllChilds();
        return reusable;
    }

    public List<String> extractReusableStructureNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Selector selector : this.selectors) {
            if (!this.isReusableSelector(selector)) continue;
            SimpleSelector simpleSelector = (SimpleSelector)selector.getHead();
            result.add(simpleSelector.getSubsequent().get(0).getFullName());
        }
        if (result.isEmpty()) {
            throw new BugHappened("Not convertible to resusable structure - caller was supposed to check for this.", (ASTCssNode)this);
        }
        return result;
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        List<ASTCssNode> result = ArraysUtils.asNonNullList(this.body);
        result.addAll(0, this.selectors);
        return result;
    }

    public void addSelectors(List<Selector> selectors) {
        this.selectors.addAll(selectors);
    }

    public void addSelector(Selector selector) {
        this.selectors.add(selector);
    }

    public void replaceSelectors(List<Selector> result) {
        for (Selector oldSelector : this.selectors) {
            oldSelector.setParent(null);
        }
        this.selectors = new ArrayList<Selector>();
        this.selectors.addAll(result);
    }

    @Override
    public RuleSet clone() {
        RuleSet result = (RuleSet)super.clone();
        result.body = this.body == null ? null : this.body.clone();
        result.selectors = ArraysUtils.deeplyClonedList(this.selectors);
        result.configureParentToAllChilds();
        return result;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.RULE_SET;
    }
}

