/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.MediaExpression;
import com.github.sommeri.less4j.core.ast.Medium;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public class MediaQuery
extends ASTCssNode {
    private Medium medium;
    private List<MediaExpression> expressions;

    public MediaQuery(HiddenTokenAwareTree token) {
        this(token, null, new ArrayList<MediaExpression>());
    }

    public MediaQuery(HiddenTokenAwareTree token, Medium medium, List<MediaExpression> expressions) {
        super(token);
        this.medium = medium;
        this.expressions = expressions;
    }

    public Medium getMedium() {
        return this.medium;
    }

    public void setMedium(Medium medium) {
        this.medium = medium;
    }

    public List<MediaExpression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<MediaExpression> expressions) {
        this.expressions = expressions;
    }

    public void addExpression(MediaExpression expression) {
        if (this.expressions == null) {
            this.expressions = new ArrayList<MediaExpression>();
        }
        this.expressions.add(expression);
    }

    public void addMember(ASTCssNode member) {
        if (member.getType() == ASTCssNodeType.MEDIUM) {
            this.setMedium((Medium)member);
        } else {
            this.addExpression((MediaExpression)member);
        }
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        List<ASTCssNode> result = ArraysUtils.asNonNullList(this.medium);
        result.addAll(this.expressions);
        return result;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.MEDIA_QUERY;
    }

    @Override
    public MediaQuery clone() {
        MediaQuery result = (MediaQuery)super.clone();
        result.medium = this.medium == null ? null : this.medium.clone();
        result.expressions = ArraysUtils.deeplyClonedList(this.expressions);
        return result;
    }
}

