/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.InterpolableName;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class IdSelector
extends ElementSubsequent {
    private InterpolableName name;

    public IdSelector(HiddenTokenAwareTree token, InterpolableName name) {
        super(token);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name.getName();
    }

    @Override
    public String getFullName() {
        return "#" + this.getName();
    }

    @Override
    public boolean isInterpolated() {
        return this.name.isInterpolated();
    }

    @Override
    public void extendName(String extension) {
        this.name.extendName(extension);
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.name);
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.ID_SELECTOR;
    }

    @Override
    public IdSelector clone() {
        IdSelector clone = (IdSelector)super.clone();
        clone.name = this.name.clone();
        clone.configureParentToAllChilds();
        return clone;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IdSelector [");
        builder.append(this.getFullName());
        builder.append("]");
        return builder.toString();
    }
}

