/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.ExpressionOperator;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ComposedExpression
extends Expression {
    private Expression left;
    private ExpressionOperator operator;
    private Expression right;

    public ComposedExpression(HiddenTokenAwareTree token, Expression left, ExpressionOperator operator, Expression right) {
        super(token);
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.COMPOSED_EXPRESSION;
    }

    public ExpressionOperator getOperator() {
        return this.operator;
    }

    public void setOperator(ExpressionOperator operator) {
        this.operator = operator;
    }

    public Expression getLeft() {
        return this.left;
    }

    public void setLeft(Expression left) {
        this.left = left;
    }

    public Expression getRight() {
        return this.right;
    }

    public void setRight(Expression right) {
        this.right = right;
    }

    public List<Expression> splitByComma() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        if (this.operator.getOperator() != ExpressionOperator.Operator.COMMA && this.operator.getOperator() != ExpressionOperator.Operator.EMPTY_OPERATOR) {
            result.add(this);
            return result;
        }
        List<Expression> left = this.splitByComma(this.getLeft());
        List<Expression> right = this.splitByComma(this.getRight());
        if (this.operator.getOperator() != ExpressionOperator.Operator.EMPTY_OPERATOR) {
            result.addAll(left);
            result.addAll(right);
            return result;
        }
        Expression lastLeft = left.get(left.size() - 1);
        Expression firstRight = right.get(0);
        result.addAll(left.subList(0, left.size() - 1));
        result.add(new ComposedExpression(lastLeft.getUnderlyingStructure(), lastLeft, this.operator, firstRight));
        result.addAll(right.subList(1, right.size()));
        return result;
    }

    private List<Expression> splitByComma(Expression expression) {
        if (expression.getType() == ASTCssNodeType.COMPOSED_EXPRESSION) {
            ComposedExpression composed = (ComposedExpression)expression;
            return composed.splitByComma();
        }
        return Arrays.asList(expression);
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.left, this.operator, this.right);
    }

    public String toString() {
        return "[" + this.left + this.operator + this.right + "]";
    }

    @Override
    public ComposedExpression clone() {
        ComposedExpression result = (ComposedExpression)super.clone();
        result.left = this.left == null ? null : this.left.clone();
        result.operator = this.operator == null ? null : this.operator.clone();
        result.right = this.right == null ? null : this.right.clone();
        result.configureParentToAllChilds();
        return result;
    }
}

