/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.commandline;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;

public class CommandLinePrint {
    private PrintStream standardOut;
    private PrintStream standardErr;

    public CommandLinePrint() {
        this(System.out, System.err);
    }

    public CommandLinePrint(PrintStream standardOut, PrintStream standardErr) {
        this.standardOut = standardOut;
        this.standardErr = standardErr;
    }

    public void printToSysout(LessCompiler.CompilationResult content, String inputfile) {
        if (content == null || content.getCss() == null) {
            this.reportCouldNotCompileTheFile(inputfile);
            return;
        }
        this.standardOut.print(content.getCss());
        this.printWarnings(inputfile, content);
    }

    void reportCouldNotCompileTheFile(String inputfile) {
        this.reportError("Could not compile the file " + inputfile);
    }

    public void printToFile(LessCompiler.CompilationResult content, String outputFile, String inputfile) {
        if (content == null || content.getCss() == null) {
            this.reportCouldNotCompileTheFile(inputfile);
            return;
        }
        this.outputFile(outputFile, content.getCss());
        this.printWarnings(inputfile, content);
    }

    public void printWarnings(String inputfile, LessCompiler.CompilationResult content) {
        if (!content.getWarnings().isEmpty()) {
            this.standardErr.println("Warnings produced by compilation of " + inputfile);
        }
        for (LessCompiler.Problem warning : content.getWarnings()) {
            this.standardErr.println(this.toWarning(warning));
        }
    }

    private String toWarning(LessCompiler.Problem warning) {
        return "WARNING " + this.toString(warning);
    }

    private String toError(LessCompiler.Problem warning) {
        return "ERROR " + this.toString(warning);
    }

    private String toString(LessCompiler.Problem problem) {
        return problem.getLine() + ":" + problem.getCharacter() + " " + problem.getMessage();
    }

    private void outputFile(String filename, String content) {
        File file = new File(filename);
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            this.reportError("Could not create the file " + filename);
            this.reportError(e);
            return;
        }
        if (!file.canWrite()) {
            this.reportError("Can not write into file " + filename);
            return;
        }
        try {
            FileWriter output = new FileWriter(file);
            IOUtils.write((String)content, (Writer)output);
            output.close();
        }
        catch (IOException e) {
            this.reportError("Can not write into file " + filename);
            this.reportError(e);
            return;
        }
    }

    protected void reportError(String message) {
        this.standardErr.println(message);
    }

    public void reportErrorsAndWarnings(Less4jException ex, String inputfile) {
        this.printWarnings(inputfile, ex.getPartialResult());
        this.reportErrors(ex, inputfile);
    }

    public void reportErrors(Less4jException ex, String inputfile) {
        if (!ex.getErrors().isEmpty()) {
            this.standardErr.println("Errors produced by compilation of " + inputfile);
        }
        HashSet<String> previousMessages = new HashSet<String>();
        for (LessCompiler.Problem error : ex.getErrors()) {
            String message = this.toError(error);
            if (previousMessages.contains(message)) continue;
            this.standardErr.println(message);
            previousMessages.add(message);
        }
    }

    protected void reportError(Throwable e) {
        e.printStackTrace(this.standardErr);
    }
}

