/*
 * Decompiled with CFR 0.152.
 */
package edu.ufl.cise.klu.tdouble;

import edu.ufl.cise.klu.common.KLU_common;
import edu.ufl.cise.klu.common.KLU_numeric;
import edu.ufl.cise.klu.common.KLU_symbolic;
import edu.ufl.cise.klu.tdouble.Dklu;
import edu.ufl.cise.klu.tdouble.Dklu_dump;
import edu.ufl.cise.klu.tdouble.Dklu_internal;
import edu.ufl.cise.klu.tdouble.Dklu_memory;
import edu.ufl.cise.klu.tdouble.Dklu_scale;

public class Dklu_factor
extends Dklu_internal {
    public static void factor2(int[] Ap, int[] Ai, double[] Ax, KLU_symbolic Symbolic, KLU_numeric Numeric, KLU_common Common) {
        int p;
        int nk;
        int k2;
        int k1;
        int block;
        int k;
        int[] lnz_block = new int[1];
        int[] unz_block = new int[1];
        int n = Symbolic.n;
        int[] P = Symbolic.P;
        int[] Q = Symbolic.Q;
        int[] R = Symbolic.R;
        double[] Lnz = Symbolic.Lnz;
        int nblocks = Symbolic.nblocks;
        int nzoff = Symbolic.nzoff;
        int[] Pnum = Numeric.Pnum;
        int[] Offp = Numeric.Offp;
        int[] Offi = Numeric.Offi;
        double[] Offx = Numeric.Offx;
        int[] Lip = Numeric.Lip;
        int[] Uip = Numeric.Uip;
        int[] Llen = Numeric.Llen;
        int[] Ulen = Numeric.Ulen;
        double[][] LUbx = Numeric.LUbx;
        double[] Udiag = Numeric.Udiag;
        double[] Rs = Numeric.Rs;
        int[] Pinv = Numeric.Pinv;
        double[] X = Numeric.Xwork;
        int[] Iwork = Numeric.Iwork;
        int[] Pblock = new int[Symbolic.maxblock];
        Common.nrealloc = 0;
        int scale = Common.scale;
        int max_lnz_block = 1;
        int max_unz_block = 1;
        if (!NDEBUG) {
            for (k = 0; k < n; ++k) {
                Pinv[k] = -1;
            }
        }
        for (k = 0; k < n; ++k) {
            Dklu_factor.ASSERT(P[k] >= 0 && P[k] < n);
            Pinv[P[k]] = k;
        }
        if (!NDEBUG) {
            for (k = 0; k < n; ++k) {
                Dklu_factor.ASSERT(Pinv[k] != -1);
            }
        }
        int lnz = 0;
        int unz = 0;
        Common.noffdiag = 0;
        Offp[0] = 0;
        if (scale >= 0) {
            Dklu_scale.klu_scale(scale, n, Ap, Ai, Ax, Rs, Pnum, Common);
            if (Common.status < 0) {
                return;
            }
        }
        if (!NDEBUG && scale > 0) {
            for (k = 0; k < n; ++k) {
                Dklu_factor.PRINTF("Rs [%d] %g\n", k, Rs[k]);
            }
        }
        for (block = 0; block < nblocks; ++block) {
            k1 = R[block];
            k2 = R[block + 1];
            nk = k2 - k1;
            Dklu_factor.PRINTF("FACTOR BLOCK %d, k1 %d k2-1 %d nk %d\n", block, k1, k2 - 1, nk);
            if (nk == 1) {
                int newrow;
                int oldrow;
                int poff = Offp[k1];
                int oldcol = Q[k1];
                int pend = Ap[oldcol + 1];
                double s = 0.0;
                if (scale <= 0) {
                    for (p = Ap[oldcol]; p < pend; ++p) {
                        oldrow = Ai[p];
                        newrow = Pinv[oldrow];
                        if (newrow < k1) {
                            Offi[poff] = oldrow;
                            Offx[poff] = Ax[p];
                            ++poff;
                            continue;
                        }
                        Dklu_factor.ASSERT(newrow == k1);
                        Dklu_factor.PRINTF("singleton block %d", block);
                        Dklu_factor.PRINT_ENTRY(Ax[p]);
                        s = Ax[p];
                    }
                } else {
                    for (p = Ap[oldcol]; p < pend; ++p) {
                        oldrow = Ai[p];
                        newrow = Pinv[oldrow];
                        if (newrow < k1) {
                            Offi[poff] = oldrow;
                            Offx[poff] = Ax[p] / Rs[oldrow];
                            ++poff;
                            continue;
                        }
                        Dklu_factor.ASSERT(newrow == k1);
                        Dklu_factor.PRINTF("singleton block %d ", block);
                        Dklu_factor.PRINT_ENTRY(Ax[p]);
                        s = Ax[p] / Rs[oldrow];
                    }
                }
                Udiag[k1] = s;
                if (Dklu_factor.IS_ZERO(s)) {
                    Common.status = 1;
                    Common.numerical_rank = k1;
                    Common.singular_col = oldcol;
                    if (Common.halt_if_singular == 1) {
                        return;
                    }
                }
                Offp[k1 + 1] = poff;
                Pnum[k1] = P[k1];
                ++lnz;
                ++unz;
                continue;
            }
            double lsize = Lnz[block] < 0.0 ? -Common.initmem : Common.initmem_amd * Lnz[block] + (double)nk;
            Numeric.LUsize[block] = Dklu.klu_kernel_factor(nk, Ap, Ai, Ax, Q, lsize, LUbx, block, Udiag, k1, Llen, k1, Ulen, k1, Lip, k1, Uip, k1, Pblock, lnz_block, unz_block, X, Iwork, k1, Pinv, Rs, Offp, Offi, Offx, Common);
            if (Common.status < 0 || Common.status == 1 && Common.halt_if_singular == 1) {
                return;
            }
            Dklu_factor.PRINTF("\n----------------------- L %d:\n", block);
            if (!NDEBUG) {
                Dklu_factor.ASSERT(Dklu_dump.klu_valid_LU(nk, 1, Lip, k1, Llen, k1, LUbx[block]));
            }
            Dklu_factor.PRINTF("\n----------------------- U %d:\n", block);
            if (!NDEBUG) {
                Dklu_factor.ASSERT(Dklu_dump.klu_valid_LU(nk, 0, Uip, k1, Ulen, k1, LUbx[block]));
            }
            lnz += lnz_block[0];
            unz += unz_block[0];
            max_lnz_block = Dklu_factor.MAX(max_lnz_block, lnz_block[0]);
            max_unz_block = Dklu_factor.MAX(max_unz_block, unz_block[0]);
            if (Lnz[block] == -1.0) {
                Lnz[block] = Dklu_factor.MAX(lnz_block[0], unz_block[0]);
            }
            Dklu_factor.PRINTF("Pnum, 1-based:\n", new Object[0]);
            for (k = 0; k < nk; ++k) {
                Dklu_factor.ASSERT(k + k1 < n);
                Dklu_factor.ASSERT(Pblock[k] + k1 < n);
                Pnum[k + k1] = P[Pblock[k] + k1];
                Dklu_factor.PRINTF("Pnum (%d + %d + 1 = %d) = %d + 1 = %d\n", k, k1, k + k1 + 1, Pnum[k + k1], Pnum[k + k1] + 1);
            }
        }
        Dklu_factor.ASSERT(nzoff == Offp[n]);
        Dklu_factor.PRINTF("\n------------------- Off diagonal entries:\n", new Object[0]);
        if (!NDEBUG) {
            Dklu_factor.ASSERT(Dklu_dump.klu_valid(n, Offp, Offi, Offx));
        }
        Numeric.lnz = lnz;
        Numeric.unz = unz;
        Numeric.max_lnz_block = max_lnz_block;
        Numeric.max_unz_block = max_unz_block;
        if (!NDEBUG) {
            for (k = 0; k < n; ++k) {
                Pinv[k] = -1;
            }
        }
        for (k = 0; k < n; ++k) {
            Dklu_factor.ASSERT(Pnum[k] >= 0 && Pnum[k] < n);
            Pinv[Pnum[k]] = k;
        }
        if (!NDEBUG) {
            for (k = 0; k < n; ++k) {
                Dklu_factor.ASSERT(Pinv[k] != -1);
            }
        }
        if (scale > 0) {
            for (k = 0; k < n; ++k) {
                X[k] = Rs[Pnum[k]];
            }
            for (k = 0; k < n; ++k) {
                Rs[k] = X[k];
            }
        }
        Dklu_factor.PRINTF("\n------------------- Off diagonal entries, old:\n", new Object[0]);
        if (!NDEBUG) {
            Dklu_factor.ASSERT(Dklu_dump.klu_valid(n, Offp, Offi, Offx));
        }
        for (p = 0; p < nzoff; ++p) {
            Dklu_factor.ASSERT(Offi[p] >= 0 && Offi[p] < n);
            Offi[p] = Pinv[Offi[p]];
        }
        Dklu_factor.PRINTF("\n------------------- Off diagonal entries, new:\n", new Object[0]);
        if (!NDEBUG) {
            Dklu_factor.ASSERT(Dklu_dump.klu_valid(n, Offp, Offi, Offx));
        }
        if (!NDEBUG) {
            Dklu_factor.PRINTF("\n ############# KLU_BTF_FACTOR done, nblocks %d\n", nblocks);
            Udiag = Numeric.Udiag;
            for (block = 0; block < nblocks && Common.status == 0; ++block) {
                k1 = R[block];
                k2 = R[block + 1];
                nk = k2 - k1;
                Dklu_factor.PRINTF("\n======================KLU_factor output: k1 %d k2 %d nk %d\n", k1, k2, nk);
                if (nk == 1) {
                    Dklu_factor.PRINTF("singleton  ", new Object[0]);
                    double ss = Udiag[k1];
                    Dklu_factor.PRINT_ENTRY(ss);
                    continue;
                }
                Lip = Numeric.Lip;
                int Lip_offset = k1;
                Llen = Numeric.Llen;
                int Llen_offset = k1;
                double[] LU = Numeric.LUbx[block];
                Dklu_factor.PRINTF("\n---- L block %d\n", block);
                if (!NDEBUG) {
                    Dklu_factor.ASSERT(Dklu_dump.klu_valid_LU(nk, 1, Lip, Lip_offset, Llen, Llen_offset, LU));
                }
                Uip = Numeric.Uip;
                int Uip_offset = k1;
                Ulen = Numeric.Ulen;
                int Ulen_offset = k1;
                Dklu_factor.PRINTF("\n---- U block %d\n", block);
                if (NDEBUG) continue;
                Dklu_factor.ASSERT(Dklu_dump.klu_valid_LU(nk, 0, Uip, Uip_offset, Ulen, Ulen_offset, LU));
            }
        }
    }

    public static KLU_numeric klu_factor(int[] Ap, int[] Ai, double[] Ax, KLU_symbolic Symbolic, KLU_common Common) {
        KLU_numeric Numeric;
        int[] ok = new int[]{1};
        if (Common == null) {
            return null;
        }
        Common.status = 0;
        Common.numerical_rank = -1;
        Common.singular_col = -1;
        if (Symbolic == null) {
            Common.status = -3;
            return null;
        }
        int n = Symbolic.n;
        int nzoff = Symbolic.nzoff;
        int nblocks = Symbolic.nblocks;
        int maxblock = Symbolic.maxblock;
        Dklu_factor.PRINTF("KLU_factor:  n %d nzoff %d nblocks %d maxblock %d\n", n, nzoff, nblocks, maxblock);
        Common.initmem_amd = Dklu_factor.MAX(1.0, Common.initmem_amd);
        Common.initmem = Dklu_factor.MAX(1.0, Common.initmem);
        Common.tol = Dklu_factor.MIN(Common.tol, 1.0);
        Common.tol = Dklu_factor.MAX(0.0, Common.tol);
        Common.memgrow = Dklu_factor.MAX(1.0, Common.memgrow);
        int n1 = n + 1;
        int nzoff1 = nzoff + 1;
        try {
            Numeric = new KLU_numeric();
        }
        catch (OutOfMemoryError e) {
            Common.status = -2;
            return null;
        }
        Numeric.n = n;
        Numeric.nblocks = nblocks;
        Numeric.nzoff = nzoff;
        Numeric.Pnum = Dklu_memory.klu_malloc_int(n, Common);
        Numeric.Offp = Dklu_memory.klu_malloc_int(n1, Common);
        Numeric.Offi = Dklu_memory.klu_malloc_int(nzoff1, Common);
        Numeric.Offx = Dklu_memory.klu_malloc_dbl(nzoff1, Common);
        Numeric.Lip = Dklu_memory.klu_malloc_int(n, Common);
        Numeric.Uip = Dklu_memory.klu_malloc_int(n, Common);
        Numeric.Llen = Dklu_memory.klu_malloc_int(n, Common);
        Numeric.Ulen = Dklu_memory.klu_malloc_int(n, Common);
        Numeric.LUsize = Dklu_memory.klu_malloc_int(nblocks, Common);
        Numeric.LUbx = new double[nblocks][];
        if (Numeric.LUbx != null) {
            for (int k = 0; k < nblocks; ++k) {
                Numeric.LUbx[k] = null;
            }
        }
        Numeric.Udiag = Dklu_memory.klu_malloc_dbl(n, Common);
        Numeric.Rs = (double[])(Common.scale > 0 ? Dklu_memory.klu_malloc_dbl(n, Common) : null);
        Numeric.Pinv = Dklu_memory.klu_malloc_int(n, Common);
        int s = n;
        int n3 = 3 * n;
        int b6 = 6 * maxblock;
        Numeric.worksize = Dklu_memory.klu_add_size_t(s, Dklu_factor.MAX(n3, b6), ok);
        try {
            if (ok[0] == 0) {
                throw new OutOfMemoryError();
            }
            Numeric.Work = new double[Numeric.worksize];
            Numeric.Xwork = Numeric.Work;
            Numeric.Iwork = new int[b6];
        }
        catch (OutOfMemoryError e) {
            Common.status = ok[0] == 1 ? -2 : -4;
            Numeric = null;
            return null;
        }
        Dklu_factor.factor2(Ap, Ai, Ax, Symbolic, Numeric, Common);
        if (Common.status < 0) {
            Numeric = null;
        } else if (Common.status == 1) {
            if (Common.halt_if_singular == 1) {
                Numeric = null;
            }
        } else if (Common.status == 0) {
            Common.numerical_rank = n;
            Common.singular_col = n;
        }
        return Numeric;
    }
}

