/*
 * Decompiled with CFR 0.152.
 */
package com.github.oowekyala.ooxml.messages;

import com.github.oowekyala.ooxml.messages.FullFilePositioner;
import com.github.oowekyala.ooxml.messages.MessageUtil;
import com.github.oowekyala.ooxml.messages.NiceXmlMessageFormatter;
import com.github.oowekyala.ooxml.messages.PartialFilePositioner;
import com.github.oowekyala.ooxml.messages.PositionedXmlDoc;
import com.github.oowekyala.ooxml.messages.PrintStreamMessageHandler;
import com.github.oowekyala.ooxml.messages.SpyInputSource;
import com.github.oowekyala.ooxml.messages.XmlException;
import com.github.oowekyala.ooxml.messages.XmlMessageHandler;
import com.github.oowekyala.ooxml.messages.XmlPositioner;
import com.github.oowekyala.ooxml.messages.XmlSeverity;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class OoxmlFacade {
    private XmlMessageHandler printer = PrintStreamMessageHandler.SYSTEM_ERR;
    private NiceXmlMessageFormatter formatter = NiceXmlMessageFormatter.FULL_MESSAGE;
    private boolean useAnsiColors = false;
    private int numContextLines = 3;

    public OoxmlFacade withFormatter(NiceXmlMessageFormatter formatter) {
        this.formatter = formatter;
        return this;
    }

    public OoxmlFacade withPrinter(XmlMessageHandler printer) {
        this.printer = printer;
        return this;
    }

    public OoxmlFacade withAnsiColors(boolean useAnsiColors) {
        this.useAnsiColors = useAnsiColors;
        return this;
    }

    public OoxmlFacade withContextLines(int numContextLines) {
        this.numContextLines = numContextLines;
        return this;
    }

    public NiceXmlMessageFormatter getFormatter() {
        return this.formatter;
    }

    public XmlMessageHandler getPrinter() {
        return this.printer;
    }

    public boolean isUseAnsiColors() {
        return this.useAnsiColors;
    }

    public int getNumContextLines() {
        return this.numContextLines;
    }

    public PositionedXmlDoc parse(DocumentBuilder domBuilder, InputSource inputSource) throws XmlException, IOException {
        return this.parseImpl(domBuilder, OoxmlFacade.spyOn(inputSource));
    }

    private PositionedXmlDoc parseImpl(DocumentBuilder builder, final SpyInputSource isource) throws XmlException, IOException {
        builder.setErrorHandler(new MyErrorHandler(this.getPrinter()){

            @Override
            XmlPositioner getPositioner() {
                return new PartialFilePositioner(isource.getReadSoFar(), isource.getSystemId());
            }
        });
        try {
            Document doc = builder.parse(isource);
            FullFilePositioner positioner = new FullFilePositioner(isource.getReadSoFar(), isource.getSystemId(), doc);
            return new PositionedXmlDoc(doc, positioner);
        }
        catch (SAXException e) {
            PartialFilePositioner positioner = new PartialFilePositioner(isource.getReadSoFar(), isource.getSystemId());
            XmlException ex = MessageUtil.createEntryBestEffort(this, positioner, XmlSeverity.ERROR, e);
            this.getPrinter().accept(ex);
            throw ex;
        }
    }

    private static SpyInputSource spyOn(InputSource inputSource) throws IOException {
        SpyInputSource is = new SpyInputSource();
        is.setSystemId(inputSource.getSystemId());
        is.setPublicId(inputSource.getPublicId());
        is.setEncoding(is.getEncoding());
        if (inputSource.getCharacterStream() != null) {
            is.setCharacterStream(inputSource.getCharacterStream());
        } else if (inputSource.getByteStream() != null) {
            is.setByteStream(inputSource.getByteStream());
        }
        if (is.getCharacterStream() != null) {
            is.setFullText(MessageUtil.readFully(is.getCharacterStream()));
        }
        return is;
    }

    private abstract class MyErrorHandler
    implements ErrorHandler {
        private final XmlMessageHandler handler;

        public MyErrorHandler(XmlMessageHandler handler) {
            this.handler = handler;
        }

        abstract XmlPositioner getPositioner();

        private XmlException parseException(SAXParseException exception, XmlSeverity severity) {
            return MessageUtil.createEntryBestEffort(OoxmlFacade.this, this.getPositioner(), severity, exception);
        }

        @Override
        public void warning(SAXParseException exception) {
            this.handler.accept(this.parseException(exception, XmlSeverity.WARNING));
        }

        @Override
        public void error(SAXParseException exception) {
            this.handler.accept(this.parseException(exception, XmlSeverity.ERROR));
        }

        @Override
        public void fatalError(SAXParseException exception) {
            XmlException ex = this.parseException(exception, XmlSeverity.ERROR);
            this.handler.accept(ex);
            throw ex;
        }
    }
}

