/*
 * Decompiled with CFR 0.152.
 */
package com.github.oowekyala.ooxml.messages;

import com.github.oowekyala.ooxml.DomUtils;
import com.github.oowekyala.ooxml.messages.NewOffsetScanner;
import com.github.oowekyala.ooxml.messages.PartialFilePositioner;
import com.github.oowekyala.ooxml.messages.XmlPosition;
import com.github.oowekyala.ooxml.messages.XmlPositioner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class FullFilePositioner
extends PartialFilePositioner
implements XmlPositioner {
    private final NewOffsetScanner scanner;

    public FullFilePositioner(String fullFileText, String systemId, Document doc) {
        super(fullFileText, systemId);
        this.scanner = new NewOffsetScanner(systemId, this.textDoc);
        this.computePositions(doc.getDocumentElement());
    }

    void computePositions(Element elt) {
        this.scanner.beginPos(elt);
        for (Element child : DomUtils.children(elt)) {
            this.computePositions(child);
        }
    }

    @Override
    public XmlPosition startPositionOf(Node node) {
        return this.scanner.beginPos(node);
    }
}

