/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import java.util.Properties;
import smile.base.svm.SVR;
import smile.math.kernel.BinarySparseLinearKernel;
import smile.math.kernel.LinearKernel;
import smile.math.kernel.MercerKernel;
import smile.math.kernel.SparseLinearKernel;
import smile.regression.BinarySparseLinearSVM;
import smile.regression.KernelMachine;
import smile.regression.LinearSVM;
import smile.regression.Regression;
import smile.regression.SparseLinearSVM;
import smile.util.SparseArray;

public class SVM {
    private SVM() {
    }

    public static Regression<double[]> fit(double[][] x, double[] y, Options options) {
        SVR svr = new SVR(new LinearKernel(), options.eps, options.C, options.tol);
        return new LinearSVM(svr.fit((T[])x, y));
    }

    public static BinarySparseLinearSVM fit(int[][] x, double[] y, int p, Options options) {
        SVR svr = new SVR(new BinarySparseLinearKernel(), options.eps, options.C, options.tol);
        return new BinarySparseLinearSVM(p, svr.fit((T[])x, y));
    }

    public static SparseLinearSVM fit(SparseArray[] x, double[] y, int p, Options options) {
        SVR<SparseArray> svr = new SVR<SparseArray>((MercerKernel<SparseArray>)new SparseLinearKernel(), options.eps, options.C, options.tol);
        return new SparseLinearSVM(p, svr.fit(x, y));
    }

    public static <T> KernelMachine<T> fit(T[] x, double[] y, MercerKernel<T> kernel, Options options) {
        SVR<T> svr = new SVR<T>(kernel, options.eps, options.C, options.tol);
        return svr.fit(x, y);
    }

    public static Regression<double[]> fit(double[][] x, double[] y, Properties params) {
        MercerKernel kernel = MercerKernel.of((String)params.getProperty("smile.svm.kernel", "linear"));
        if (kernel instanceof LinearKernel) {
            return SVM.fit(x, y, Options.of(params));
        }
        return SVM.fit(x, y, kernel, Options.of(params));
    }

    public record Options(double eps, double C, double tol) {
        public Options {
            if (eps <= 0.0) {
                throw new IllegalArgumentException("Invalid epsilon: " + eps);
            }
            if (tol <= 0.0) {
                throw new IllegalArgumentException("Invalid tolerance: " + tol);
            }
            if (C < 0.0) {
                throw new IllegalArgumentException("Invalid maximum number of iterations: " + C);
            }
        }

        public Options(double eps, double C) {
            this(eps, C, 0.001);
        }

        public Properties toProperties() {
            Properties props = new Properties();
            props.setProperty("smile.svm.epsilon", Double.toString(this.eps));
            props.setProperty("smile.svm.C", Double.toString(this.C));
            props.setProperty("smile.svm.tolerance", Double.toString(this.tol));
            return props;
        }

        public static Options of(Properties props) {
            double eps = Double.parseDouble(props.getProperty("smile.svm.epsilon", "1.0"));
            double C = Double.parseDouble(props.getProperty("smile.svm.C", "1.0"));
            double tol = Double.parseDouble(props.getProperty("smile.svm.tolerance", "1E-3"));
            return new Options(eps, C, tol);
        }
    }
}

