/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.base.cart.CART;
import smile.base.cart.Loss;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.formula.Formula;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.data.vector.ValueVector;
import smile.feature.importance.TreeSHAP;
import smile.math.MathEx;
import smile.regression.DataFrameRegression;
import smile.regression.RegressionTree;
import smile.util.IterativeAlgorithmController;
import smile.validation.RegressionMetrics;

public class RandomForest
implements DataFrameRegression,
TreeSHAP {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = LoggerFactory.getLogger(RandomForest.class);
    private final Formula formula;
    private final Model[] models;
    private final RegressionMetrics metrics;
    private final double[] importance;

    public RandomForest(Formula formula, Model[] models, RegressionMetrics metrics, double[] importance) {
        this.formula = formula;
        this.models = models;
        this.metrics = metrics;
        this.importance = importance;
    }

    public static RandomForest fit(Formula formula, DataFrame data) {
        return RandomForest.fit(formula, data, new Options(500));
    }

    public static RandomForest fit(Formula formula, DataFrame data, Options options) {
        formula = formula.expand(data.schema());
        DataFrame x = formula.x(data);
        ValueVector response = formula.y(data);
        StructField field = response.field();
        double[] y = response.toDoubleArray();
        if (options.mtry > x.ncol()) {
            throw new IllegalArgumentException("Invalid number of variables to split on at a node of the tree: " + options.mtry);
        }
        int mtry = options.mtry > 0 ? options.mtry : Math.max(x.ncol() / 3, 1);
        int maxNodes = options.maxNodes > 0 ? options.maxNodes : Math.max(2, data.size() / 5);
        int ntrees = options.ntrees;
        double subsample = options.subsample;
        int n = x.size();
        double[] prediction = new double[n];
        int[] oob = new int[n];
        int[][] order = CART.order(x);
        Model[] models = (Model[])IntStream.range(0, ntrees).parallel().mapToObj(t -> {
            if (options.seeds != null) {
                MathEx.setSeed((long)options.seeds[t]);
            }
            int[] samples = new int[n];
            if (subsample == 1.0) {
                for (int i = 0; i < n; ++i) {
                    int n2 = MathEx.randomInt((int)n);
                    samples[n2] = samples[n2] + 1;
                }
            } else {
                int[] permutation = MathEx.permutate((int)n);
                int N = (int)Math.round((double)n * subsample);
                for (int i = 0; i < N; ++i) {
                    samples[permutation[i]] = 1;
                }
            }
            long start = System.nanoTime();
            RegressionTree tree = new RegressionTree(x, Loss.ls(y), field, options.maxDepth, maxNodes, options.nodeSize, mtry, samples, order);
            double fitTime = (double)(System.nanoTime() - start) / 1000000.0;
            start = System.nanoTime();
            int noob = 0;
            for (int i = 0; i < n; ++i) {
                if (samples[i] != 0) continue;
                ++noob;
            }
            double[] truth = new double[noob];
            double[] predict = new double[noob];
            int j = 0;
            for (int i = 0; i < n; ++i) {
                double yi;
                if (samples[i] != 0) continue;
                truth[j] = y[i];
                predict[j] = yi = tree.predict(x.get(i));
                int n3 = i;
                oob[n3] = oob[n3] + 1;
                int n4 = i;
                prediction[n4] = prediction[n4] + yi;
                ++j;
            }
            double scoreTime = (double)(System.nanoTime() - start) / 1000000.0;
            RegressionMetrics metrics = RegressionMetrics.of(fitTime, scoreTime, truth, predict);
            logger.info("Tree {}: OOB = {}, R2 = {}%", new Object[]{t + 1, noob, String.format("%.2f", 100.0 * metrics.r2())});
            if (options.controller != null) {
                options.controller.submit((Object)new TrainingStatus(t + 1, metrics));
            }
            return new Model(tree, metrics);
        }).toArray(Model[]::new);
        double fitTime = 0.0;
        double scoreTime = 0.0;
        for (Model model : models) {
            fitTime += model.metrics.fitTime();
            scoreTime += model.metrics.scoreTime();
        }
        for (int i = 0; i < n; ++i) {
            if (oob[i] <= 0) continue;
            int n2 = i;
            prediction[n2] = prediction[n2] / (double)oob[i];
        }
        RegressionMetrics metrics = RegressionMetrics.of(fitTime, scoreTime, y, prediction);
        double[] importance = RandomForest.calculateImportance(models);
        return new RandomForest(formula, models, metrics, importance);
    }

    private static double[] calculateImportance(Model[] models) {
        double[] importance = new double[models[0].tree.importance().length];
        for (Model model : models) {
            double[] imp = model.tree.importance();
            for (int i = 0; i < imp.length; ++i) {
                int n = i;
                importance[n] = importance[n] + imp[i];
            }
        }
        return importance;
    }

    @Override
    public Formula formula() {
        return this.formula;
    }

    @Override
    public StructType schema() {
        return this.models[0].tree.schema();
    }

    public RegressionMetrics metrics() {
        return this.metrics;
    }

    public double[] importance() {
        return this.importance;
    }

    public int size() {
        return this.models.length;
    }

    public Model[] models() {
        return this.models;
    }

    public RegressionTree[] trees() {
        return (RegressionTree[])Arrays.stream(this.models).map(model -> model.tree).toArray(RegressionTree[]::new);
    }

    public RandomForest trim(int ntrees) {
        if (ntrees > this.models.length) {
            throw new IllegalArgumentException("The new model size is larger than the current size.");
        }
        if (ntrees <= 0) {
            throw new IllegalArgumentException("Invalid new model size: " + ntrees);
        }
        Arrays.sort(this.models);
        return new RandomForest(this.formula, Arrays.copyOf(this.models, ntrees), this.metrics, this.importance);
    }

    public RandomForest merge(RandomForest other) {
        if (!this.formula.equals((Object)other.formula)) {
            throw new IllegalArgumentException("RandomForest have different model formula");
        }
        Model[] forest = new Model[this.models.length + other.models.length];
        System.arraycopy(this.models, 0, forest, 0, this.models.length);
        System.arraycopy(other.models, 0, forest, this.models.length, other.models.length);
        RegressionMetrics mergedMetrics = new RegressionMetrics(this.metrics.fitTime() + other.metrics.fitTime(), this.metrics.scoreTime() + other.metrics.scoreTime(), this.metrics.size(), (this.metrics.rss() + other.metrics.rss()) / 2.0, (this.metrics.mse() + other.metrics.mse()) / 2.0, (this.metrics.rmse() + other.metrics.rmse()) / 2.0, (this.metrics.mad() + other.metrics.mad()) / 2.0, (this.metrics.r2() + other.metrics.r2()) / 2.0);
        double[] mergedImportance = (double[])this.importance.clone();
        for (int i = 0; i < this.importance.length; ++i) {
            int n = i;
            mergedImportance[n] = mergedImportance[n] + other.importance[i];
        }
        return new RandomForest(this.formula, forest, mergedMetrics, mergedImportance);
    }

    @Override
    public double predict(Tuple x) {
        Tuple xt = this.formula.x(x);
        double y = 0.0;
        for (Model model : this.models) {
            y += model.tree.predict(xt);
        }
        return y / (double)this.models.length;
    }

    public double[][] test(DataFrame data) {
        DataFrame x = this.formula.x(data);
        int n = x.size();
        int ntrees = this.models.length;
        double[][] prediction = new double[ntrees][n];
        for (int j = 0; j < n; ++j) {
            Tuple xj = x.get(j);
            double base = 0.0;
            for (int i = 0; i < ntrees; ++i) {
                prediction[i][j] = (base += this.models[i].tree.predict(xj)) / (double)(i + 1);
            }
        }
        return prediction;
    }

    public record Model(RegressionTree tree, RegressionMetrics metrics) implements Serializable,
    Comparable<Model>
    {
        @Override
        public int compareTo(Model o) {
            return Double.compare(this.metrics.rmse(), o.metrics.rmse());
        }
    }

    public record Options(int ntrees, int mtry, int maxDepth, int maxNodes, int nodeSize, double subsample, long[] seeds, IterativeAlgorithmController<TrainingStatus> controller) {
        public Options {
            if (ntrees < 1) {
                throw new IllegalArgumentException("Invalid number of trees: " + ntrees);
            }
            if (maxDepth < 2) {
                throw new IllegalArgumentException("Invalid maximal tree depth: " + maxDepth);
            }
            if (nodeSize < 1) {
                throw new IllegalArgumentException("Invalid node size: " + nodeSize);
            }
            if (subsample <= 0.0 || subsample > 1.0) {
                throw new IllegalArgumentException("Invalid sampling rate: " + subsample);
            }
            if (seeds != null && seeds.length < ntrees) {
                throw new IllegalArgumentException("The number of RNG seeds is fewer than that of trees: " + seeds.length);
            }
        }

        public Options(int ntrees) {
            this(ntrees, 0);
        }

        public Options(int ntrees, int mtry) {
            this(ntrees, mtry, 20, 0, 5, 1.0, null, null);
        }

        public Properties toProperties() {
            Properties props = new Properties();
            props.setProperty("smile.random_forest.trees", Integer.toString(this.ntrees));
            props.setProperty("smile.random_forest.mtry", Integer.toString(this.mtry));
            props.setProperty("smile.random_forest.max_depth", Integer.toString(this.maxDepth));
            props.setProperty("smile.random_forest.max_nodes", Integer.toString(this.maxNodes));
            props.setProperty("smile.random_forest.node_size", Integer.toString(this.nodeSize));
            props.setProperty("smile.random_forest.sampling_rate", Double.toString(this.subsample));
            return props;
        }

        public static Options of(Properties props) {
            int ntrees = Integer.parseInt(props.getProperty("smile.random_forest.trees", "500"));
            int mtry = Integer.parseInt(props.getProperty("smile.random_forest.mtry", "0"));
            int maxDepth = Integer.parseInt(props.getProperty("smile.random_forest.max_depth", "20"));
            int maxNodes = Integer.parseInt(props.getProperty("smile.random_forest.max_nodes", "0"));
            int nodeSize = Integer.parseInt(props.getProperty("smile.random_forest.node_size", "5"));
            double subsample = Double.parseDouble(props.getProperty("smile.random_forest.sampling_rate", "1.0"));
            return new Options(ntrees, mtry, maxDepth, maxNodes, nodeSize, subsample, null, null);
        }
    }

    public record TrainingStatus(int tree, RegressionMetrics metrics) {
    }
}

