/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import java.util.List;
import java.util.Properties;
import smile.data.SparseDataset;
import smile.graph.AdjacencyList;
import smile.graph.Graph;
import smile.graph.NearestNeighborGraph;
import smile.math.MathEx;
import smile.math.distance.Distance;
import smile.tensor.ARPACK;
import smile.tensor.DenseMatrix;
import smile.tensor.EVD;
import smile.tensor.Matrix;
import smile.tensor.SparseMatrix;
import smile.util.SparseArray;

public class LaplacianEigenmap {
    private LaplacianEigenmap() {
    }

    public static double[][] fit(double[][] data, Options options) {
        return LaplacianEigenmap.fit(data, MathEx::distance, options);
    }

    public static <T> double[][] fit(T[] data, Distance<T> distance, Options options) {
        NearestNeighborGraph nng = NearestNeighborGraph.of((Object[])data, distance, (int)options.k);
        return LaplacianEigenmap.fit(nng.largest(false), options);
    }

    public static double[][] fit(NearestNeighborGraph nng, Options options) {
        int i;
        AdjacencyList graph = nng.graph(false);
        int n = graph.getVertexCount();
        int d = options.d;
        double t = options.t;
        double[] D = new double[n];
        double gamma = -1.0 / t;
        SparseArray[] W = new SparseArray[n];
        for (i = 0; i < n; ++i) {
            SparseArray Wi = new SparseArray();
            List edges = graph.getEdges(i);
            for (Graph.Edge edge : edges) {
                double w = t <= 0.0 ? 1.0 : Math.exp(gamma * edge.weight() * edge.weight());
                Wi.set(edge.v(), w);
                int n2 = i;
                D[n2] = D[n2] + w;
            }
            D[i] = 1.0 / Math.sqrt(D[i]);
            W[i] = Wi;
        }
        for (i = 0; i < n; ++i) {
            double Di = D[i];
            SparseArray Wi = W[i];
            Wi.update((j, value) -> -Di * value * D[j]);
            Wi.set(i, 1.0);
        }
        SparseMatrix L = SparseDataset.of((SparseArray[])W, (int)n).toMatrix();
        EVD eigen = ARPACK.syev((Matrix)L, (ARPACK.SymmOption)ARPACK.SymmOption.SM, (int)Math.min(10 * (d + 1), n - 1));
        DenseMatrix V = eigen.Vr();
        double[][] coordinates = new double[n][d];
        int j2 = d;
        while (--j2 >= 0) {
            int i2;
            double norm = 0.0;
            int c = V.ncol() - j2 - 2;
            for (i2 = 0; i2 < n; ++i2) {
                double xi;
                coordinates[i2][j2] = xi = V.get(i2, c) * D[i2];
                norm += xi * xi;
            }
            norm = Math.sqrt(norm);
            for (i2 = 0; i2 < n; ++i2) {
                double[] dArray = coordinates[i2];
                int n3 = j2;
                dArray[n3] = dArray[n3] / norm;
            }
        }
        return coordinates;
    }

    public record Options(int k, int d, double t) {
        public Options {
            if (k < 2) {
                throw new IllegalArgumentException("Invalid number of nearest neighbors: " + k);
            }
            if (d < 2) {
                throw new IllegalArgumentException("Invalid dimension of feature space: " + d);
            }
        }

        public Options(int k) {
            this(k, 2, -1.0);
        }

        public Properties toProperties() {
            Properties props = new Properties();
            props.setProperty("smile.laplacian_eigenmap.k", Integer.toString(this.k));
            props.setProperty("smile.laplacian_eigenmap.d", Integer.toString(this.d));
            props.setProperty("smile.laplacian_eigenmap.t", Double.toString(this.t));
            return props;
        }

        public static Options of(Properties props) {
            int k = Integer.parseInt(props.getProperty("smile.laplacian_eigenmap.k", "7"));
            int d = Integer.parseInt(props.getProperty("smile.laplacian_eigenmap.d", "2"));
            double t = Double.parseDouble(props.getProperty("smile.laplacian_eigenmap.t", "-1"));
            return new Options(k, d, t);
        }
    }
}

