/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import smile.base.svm.KernelMachine;
import smile.base.svm.LinearKernelMachine;
import smile.classification.AbstractClassifier;
import smile.util.IntSet;

public class BinarySparseLinearSVM
extends AbstractClassifier<int[]> {
    private final LinearKernelMachine model;

    public BinarySparseLinearSVM(int p, KernelMachine<int[]> svm) {
        super(new IntSet(new int[]{-1, 1}));
        this.model = LinearKernelMachine.binary(p, svm);
    }

    public double[] weights() {
        return this.model.weights();
    }

    public double intercept() {
        return this.model.intercept();
    }

    @Override
    public int predict(int[] x) {
        return this.model.f(x) > 0.0 ? 1 : -1;
    }

    @Override
    public double score(int[] x) {
        return this.model.f(x);
    }
}

