/*
 * Decompiled with CFR 0.152.
 */
package smile.anomaly;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import smile.anomaly.IsolationForest;
import smile.math.MathEx;
import smile.stat.distribution.GaussianDistribution;

public class IsolationTree
implements Serializable {
    private final Node root;

    public IsolationTree(List<double[]> data, int maxDepth, int extensionLevel) {
        this.root = this.buildNode(data, maxDepth, extensionLevel, 0);
    }

    public double path(double[] x) {
        return this.root.path(x);
    }

    private Node buildNode(List<double[]> data, int maxDepth, int extensionLevel, int depth) {
        if (depth >= maxDepth || data.size() <= 1) {
            double adjustedDepth = depth;
            if (data.size() > 1) {
                adjustedDepth += IsolationForest.factor(data.size());
            }
            return new Node(adjustedDepth);
        }
        double[] min = (double[])data.getFirst().clone();
        double[] max = (double[])data.getFirst().clone();
        int p = min.length;
        for (double[] x : data) {
            for (int i = 0; i < p; ++i) {
                if (x[i] < min[i]) {
                    min[i] = x[i];
                    continue;
                }
                if (!(x[i] > max[i])) continue;
                max[i] = x[i];
            }
        }
        double[] intercept = new double[p];
        for (int i = 0; i < p; ++i) {
            intercept[i] = MathEx.random((double)min[i], (double)max[i]);
        }
        GaussianDistribution gauss = GaussianDistribution.getInstance();
        double[] slope = new double[p];
        for (int i = 0; i < p; ++i) {
            slope[i] = gauss.rand();
        }
        int[] index = MathEx.permutate((int)p);
        for (int i = 0; i < p - extensionLevel - 1; ++i) {
            slope[index[i]] = 0.0;
        }
        double bias = MathEx.dot((double[])slope, (double[])intercept);
        ArrayList<double[]> leftData = new ArrayList<double[]>();
        ArrayList<double[]> rightData = new ArrayList<double[]>();
        for (double[] x : data) {
            double dot = MathEx.dot((double[])x, (double[])slope);
            if (dot < bias) {
                leftData.add(x);
                continue;
            }
            rightData.add(x);
        }
        Node left = this.buildNode(leftData, maxDepth, extensionLevel, depth + 1);
        Node right = this.buildNode(rightData, maxDepth, extensionLevel, depth + 1);
        return new Node(depth, slope, intercept, bias, left, right);
    }

    static class Node
    implements Serializable {
        final double depth;
        final double[] slope;
        final double[] intercept;
        final double bias;
        final Node left;
        final Node right;

        Node(double depth) {
            this(depth, null, null, 0.0, null, null);
        }

        Node(double depth, double[] slope, double[] intercept, double bias, Node left, Node right) {
            this.depth = depth;
            this.slope = slope;
            this.intercept = intercept;
            this.bias = bias;
            this.left = left;
            this.right = right;
        }

        public double path(double[] x) {
            if (this.left == null && this.right == null) {
                return this.depth;
            }
            double dot = MathEx.dot((double[])x, (double[])this.slope);
            if (dot < this.bias) {
                return this.left.path(x);
            }
            return this.right.path(x);
        }
    }
}

