/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Flow;
import java.util.concurrent.SubmissionPublisher;

public class IterativeAlgorithmController<T>
implements AutoCloseable {
    private boolean interrupted = false;
    private final SubmissionPublisher<T> publisher;

    public IterativeAlgorithmController() {
        this(Executors.newFixedThreadPool(1), 2048);
    }

    public IterativeAlgorithmController(Executor executor, int maxBufferCapacity) {
        this.publisher = new SubmissionPublisher(executor, maxBufferCapacity);
    }

    @Override
    public void close() {
        this.publisher.close();
    }

    public final boolean isInterrupted() {
        return this.interrupted;
    }

    public void stop() {
        this.interrupted = true;
    }

    public void subscribe(Flow.Subscriber<T> subscriber) {
        this.publisher.subscribe(subscriber);
    }

    public void submit(T status) {
        this.publisher.submit(status);
    }
}

