/*
 * Decompiled with CFR 0.152.
 */
package smile.tensor;

import smile.linalg.Transpose;
import smile.tensor.Matrix;
import smile.tensor.ScalarType;
import smile.tensor.Vector;

public class AtA
implements Matrix {
    private final Matrix A;
    private final int m;
    private final int n;
    private final Vector Ax;

    public AtA(Matrix A) {
        this.A = A;
        this.m = Math.max(A.nrow(), A.ncol());
        this.n = Math.min(A.nrow(), A.ncol());
        this.Ax = A.vector(this.m + this.n);
    }

    @Override
    public ScalarType scalarType() {
        return this.A.scalarType();
    }

    @Override
    public int nrow() {
        return this.n;
    }

    @Override
    public int ncol() {
        return this.n;
    }

    @Override
    public long length() {
        return this.A.length();
    }

    @Override
    public double get(int i, int j) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(int i, int j, double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int i, int j, double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sub(int i, int j, double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void mul(int i, int j, double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void div(int i, int j, double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix scale(double alpha) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix transpose() {
        return this;
    }

    @Override
    public void mv(Transpose trans, double alpha, Vector x, double beta, Vector y) {
        if (this.A.nrow() >= this.A.ncol()) {
            this.A.mv(x, this.Ax);
            this.A.mv(Transpose.TRANSPOSE, alpha, this.Ax, beta, y);
        } else {
            this.A.tv(x, this.Ax);
            this.A.mv(Transpose.NO_TRANSPOSE, alpha, this.Ax, beta, y);
        }
    }

    @Override
    public void mv(Vector work, int inputOffset, int outputOffset) {
        Vector.copy(work, inputOffset, this.Ax, 0, this.n);
        if (this.A.nrow() >= this.A.ncol()) {
            this.A.mv(this.Ax, 0, this.n);
            this.A.tv(this.Ax, this.n, 0);
        } else {
            this.A.tv(this.Ax, 0, this.n);
            this.A.mv(this.Ax, this.n, 0);
        }
        Vector.copy(this.Ax, 0, work, outputOffset, this.n);
    }

    @Override
    public void tv(Vector work, int inputOffset, int outputOffset) {
        this.mv(work, inputOffset, outputOffset);
    }
}

