/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.hypothesis;

import java.util.Arrays;
import smile.math.MathEx;
import smile.math.special.Beta;
import smile.util.IntSet;

public record FTest(double f, int df1, int df2, double pvalue) {
    @Override
    public String toString() {
        return String.format("F-test(f = %.4f, df1 = %d, df2 = %d, p-value = %G)", this.f, this.df1, this.df2, this.pvalue);
    }

    public static FTest test(double[] x, double[] y) {
        int df2;
        int df1;
        double f;
        double var2;
        int n1 = x.length;
        int n2 = y.length;
        double var1 = MathEx.var(x);
        if (var1 > (var2 = MathEx.var(y))) {
            f = var1 / var2;
            df1 = n1 - 1;
            df2 = n2 - 1;
        } else {
            f = var2 / var1;
            df1 = n2 - 1;
            df2 = n1 - 1;
        }
        double p = 2.0 * Beta.regularizedIncompleteBetaFunction(0.5 * (double)df2, 0.5 * (double)df1, (double)df2 / ((double)df2 + (double)df1 * f));
        if (p > 1.0) {
            p = 2.0 - p;
        }
        return new FTest(f, df1, df2, p);
    }

    public static FTest test(int[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vectors have different size");
        }
        int[] labels = MathEx.unique(x);
        int k = labels.length;
        if (k < 2) {
            throw new IllegalArgumentException("Categorical variable should have two or more levels.");
        }
        Arrays.sort(labels);
        IntSet encoder = new IntSet(labels);
        int[] clazz = Arrays.stream(x).map(encoder::indexOf).toArray();
        double ybar = MathEx.mean(y);
        double[] mu = new double[k];
        int n = x.length;
        int[] ni = new int[k];
        double sst = 0.0;
        for (int i = 0; i < n; ++i) {
            int n2 = clazz[i];
            mu[n2] = mu[n2] + y[i];
            int n3 = clazz[i];
            ni[n3] = ni[n3] + 1;
            sst += (y[i] - ybar) * (y[i] - ybar);
        }
        double ssb = 0.0;
        for (int i = 0; i < k; ++i) {
            int n4 = i;
            mu[n4] = mu[n4] / (double)ni[i];
            ssb += (double)ni[i] * (mu[i] - ybar) * (mu[i] - ybar);
        }
        double ssw = sst - ssb;
        int dfb = k - 1;
        int dfw = n - k;
        double f = ssb / (double)dfb / (ssw / (double)dfw);
        double p = Beta.regularizedIncompleteBetaFunction(0.5 * (double)dfw, 0.5 * (double)dfb, (double)dfw / ((double)dfw + (double)dfb * f));
        return new FTest(f, dfb, dfw, p);
    }
}

