/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.MathEx;
import smile.math.kernel.HyperbolicTangent;
import smile.math.kernel.MercerKernel;

public class BinarySparseHyperbolicTangentKernel
extends HyperbolicTangent
implements MercerKernel<int[]> {
    public BinarySparseHyperbolicTangentKernel() {
        this(1.0, 0.0);
    }

    public BinarySparseHyperbolicTangentKernel(double scale, double offset) {
        this(scale, offset, new double[]{0.01, 1.0E-5}, new double[]{100.0, 100000.0});
    }

    public BinarySparseHyperbolicTangentKernel(double scale, double offset, double[] lo, double[] hi) {
        super(scale, offset, lo, hi);
    }

    @Override
    public double k(int[] x, int[] y) {
        return this.k(MathEx.dot(x, y));
    }

    @Override
    public double[] kg(int[] x, int[] y) {
        return this.kg(MathEx.dot(x, y));
    }

    public BinarySparseHyperbolicTangentKernel of(double[] params) {
        return new BinarySparseHyperbolicTangentKernel(params[0], params[1], this.lo, this.hi);
    }

    @Override
    public double[] hyperparameters() {
        return new double[]{this.scale, this.offset};
    }

    @Override
    public double[] lo() {
        return this.lo;
    }

    @Override
    public double[] hi() {
        return this.hi;
    }
}

