/*
 * Decompiled with CFR 0.152.
 */
package smile.math.distance;

import smile.linalg.UPLO;
import smile.math.distance.Metric;
import smile.tensor.DenseMatrix;
import smile.tensor.Vector;

public class MahalanobisDistance
implements Metric<double[]> {
    private static final long serialVersionUID = 1L;
    private final DenseMatrix sigma;
    private final DenseMatrix sigmaInv;

    public MahalanobisDistance(double[][] cov) {
        this.sigma = DenseMatrix.of(cov);
        this.sigma.withUplo(UPLO.LOWER);
        this.sigmaInv = this.sigma.inverse();
    }

    public String toString() {
        return String.format("Mahalanobis Distance(%s)", this.sigma);
    }

    @Override
    public double d(double[] x, double[] y) {
        if (x.length != this.sigma.nrow()) {
            throw new IllegalArgumentException(String.format("Array x[%d] has different dimension with Sigma[%d][%d].", x.length, this.sigma.nrow(), this.sigma.ncol()));
        }
        if (y.length != this.sigma.nrow()) {
            throw new IllegalArgumentException(String.format("Array y[%d] has different dimension with Sigma[%d][%d].", y.length, this.sigma.nrow(), this.sigma.ncol()));
        }
        int n = x.length;
        double[] z = new double[n];
        for (int i = 0; i < n; ++i) {
            z[i] = x[i] - y[i];
        }
        double dist = this.sigmaInv.xAx(Vector.column(z));
        return Math.sqrt(dist);
    }
}

