/*
 * Decompiled with CFR 0.152.
 */
package smile.math;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import smile.math.MathEx;
import smile.sort.IQAgent;
import smile.util.function.Function;

public class Scaler
implements Function {
    private static final long serialVersionUID = 2L;
    private final double scale;
    private final double offset;
    private final boolean clip;

    public Scaler(double scale, double offset, boolean clip) {
        this.scale = MathEx.isZero(scale) ? 1.0 : scale;
        this.offset = offset;
        this.clip = clip;
    }

    @Override
    public double f(double x) {
        double y = (x - this.offset) / this.scale;
        if (this.clip) {
            if (y < 0.0) {
                y = 0.0;
            }
            if (y > 1.0) {
                y = 1.0;
            }
        }
        return y;
    }

    @Override
    public double inv(double x) {
        return x * this.scale + this.offset;
    }

    public static Scaler minmax(double[] data) {
        return new Scaler(MathEx.min(data), MathEx.max(data), true);
    }

    public static Scaler winsor(double[] data) {
        return Scaler.winsor(data, 0.05, 0.95);
    }

    public static Scaler winsor(double[] data, double lower, double upper) {
        IQAgent agent = new IQAgent();
        for (double x : data) {
            agent.add(x);
        }
        return new Scaler(agent.quantile(lower), agent.quantile(upper), true);
    }

    public static Scaler standardizer(double[] data) {
        return Scaler.standardizer(data, false);
    }

    public static Scaler standardizer(double[] data, boolean robust) {
        if (robust) {
            IQAgent agent = new IQAgent();
            for (double x : data) {
                agent.add(x);
            }
            double median = agent.quantile(0.5);
            double iqr = agent.quantile(0.75) - agent.quantile(0.25);
            return new Scaler(median, iqr, false);
        }
        return new Scaler(MathEx.mean(data), MathEx.stdev(data), false);
    }

    public static Scaler of(String scaler, double[] data) {
        if (scaler == null || scaler.isEmpty()) {
            return null;
        }
        if ((scaler = scaler.trim().toLowerCase(Locale.ROOT)).equals("minmax")) {
            return Scaler.minmax(data);
        }
        Pattern winsor = Pattern.compile(String.format("winsor\\((%s),\\s*(%s)\\)", "[-+]?[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?", "[-+]?[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?"));
        Matcher m = winsor.matcher(scaler);
        if (m.matches()) {
            double lower = Double.parseDouble(m.group(1));
            double upper = Double.parseDouble(m.group(2));
            return Scaler.winsor(data, lower, upper);
        }
        Pattern standardizer = Pattern.compile(String.format("standardizer(\\(\\s*(%s)\\))?", "(true|false)"));
        m = standardizer.matcher(scaler);
        if (m.matches()) {
            boolean robust = false;
            if (m.group(1) != null) {
                robust = Boolean.parseBoolean(m.group(2));
            }
            return Scaler.standardizer(data, robust);
        }
        throw new IllegalArgumentException("Unsupported scaler: " + scaler);
    }
}

