/*
 * Decompiled with CFR 0.152.
 */
package smile.math;

import java.io.Serializable;

public record Complex(double re, double im) implements Serializable
{
    private static final long serialVersionUID = 2L;

    public static Complex of(double real) {
        return new Complex(real, 0.0);
    }

    public static Complex of(double real, double imag) {
        return new Complex(real, imag);
    }

    @Override
    public String toString() {
        if (this.im == 0.0) {
            return String.format("%.4f", this.re);
        }
        if (this.re == 0.0) {
            return String.format("%.4fi", this.im);
        }
        if (this.im < 0.0) {
            return String.format("%.4f - %.4fi", this.re, -this.im);
        }
        return String.format("%.4f + %.4fi", this.re, this.im);
    }

    public Complex add(Complex b) {
        Complex a = this;
        double real = a.re + b.re;
        double imag = a.im + b.im;
        return new Complex(real, imag);
    }

    public Complex sub(Complex b) {
        Complex a = this;
        double real = a.re - b.re;
        double imag = a.im - b.im;
        return new Complex(real, imag);
    }

    public Complex mul(Complex b) {
        Complex a = this;
        double real = a.re * b.re - a.im * b.im;
        double imag = a.re * b.im + a.im * b.re;
        return new Complex(real, imag);
    }

    public Complex scale(double b) {
        return new Complex(b * this.re, b * this.im);
    }

    public Complex div(Complex b) {
        double cdivi;
        double cdivr;
        if (Math.abs(b.re) > Math.abs(b.im)) {
            double r = b.im / b.re;
            double d = b.re + r * b.im;
            cdivr = (this.re + r * this.im) / d;
            cdivi = (this.im - r * this.re) / d;
        } else {
            double r = b.re / b.im;
            double d = b.im + r * b.re;
            cdivr = (r * this.re + this.im) / d;
            cdivi = (r * this.im - this.re) / d;
        }
        return new Complex(cdivr, cdivi);
    }

    public double abs() {
        return Math.hypot(this.re, this.im);
    }

    public double phase() {
        return Math.atan2(this.im, this.re);
    }

    public Complex conjugate() {
        return new Complex(this.re, -this.im);
    }

    public Complex reciprocal() {
        double scale = this.re * this.re + this.im * this.im;
        return new Complex(this.re / scale, -this.im / scale);
    }

    public Complex exp() {
        return new Complex(Math.exp(this.re) * Math.cos(this.im), Math.exp(this.re) * Math.sin(this.im));
    }

    public Complex sin() {
        return new Complex(Math.sin(this.re) * Math.cosh(this.im), Math.cos(this.re) * Math.sinh(this.im));
    }

    public Complex cos() {
        return new Complex(Math.cos(this.re) * Math.cosh(this.im), -Math.sin(this.re) * Math.sinh(this.im));
    }

    public Complex tan() {
        return this.sin().div(this.cos());
    }

    public static class Array {
        public final int length;
        private final double[] data;

        public Array(int length) {
            if (length < 0) {
                throw new IllegalArgumentException("Negative array length: " + length);
            }
            this.length = length;
            this.data = new double[length * 2];
        }

        public Complex get(int i) {
            int idx = i << 1;
            return new Complex(this.data[idx], this.data[idx + 1]);
        }

        public Complex apply(int i) {
            return this.get(i);
        }

        public void set(int i, Complex c) {
            int idx = i << 1;
            this.data[idx] = c.re;
            this.data[idx + 1] = c.im;
        }

        public void set(int i, double re) {
            int idx = i << 1;
            this.data[idx] = re;
        }

        public void update(int i, Complex c) {
            this.set(i, c);
        }

        public void update(int i, double re) {
            this.set(i, re);
        }

        public static Array of(Complex ... x) {
            Array a = new Array(x.length);
            for (int i = 0; i < x.length; ++i) {
                a.set(i, x[i]);
            }
            return a;
        }
    }
}

